/*
 * Decompiled with CFR 0.152.
 */
package com.explorestack.protobuf.ext;

import com.explorestack.protobuf.Duration;
import com.explorestack.protobuf.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public final class Timestamps {
    static final long TIMESTAMP_SECONDS_MIN = -62135596800L;
    static final long TIMESTAMP_SECONDS_MAX = 253402300799L;
    static final long NANOS_PER_SECOND = 1000000000L;
    static final long NANOS_PER_MILLISECOND = 1000000L;
    static final long NANOS_PER_MICROSECOND = 1000L;
    static final long MILLIS_PER_SECOND = 1000L;
    private static final ThreadLocal<SimpleDateFormat> timestampFormat = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return Timestamps.createTimestampFormat();
        }
    };

    private static SimpleDateFormat createTimestampFormat() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.ENGLISH);
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        calendar.setGregorianChange(new Date(Long.MIN_VALUE));
        sdf.setCalendar(calendar);
        return sdf;
    }

    private Timestamps() {
    }

    public static boolean isValid(long seconds, int nanos) {
        if (seconds < -62135596800L || seconds > 253402300799L) {
            return false;
        }
        return nanos >= 0 && (long)nanos < 1000000000L;
    }

    public static Timestamp checkValid(Timestamp timestamp) {
        int nanos;
        long seconds = timestamp.getSeconds();
        if (!Timestamps.isValid(seconds, nanos = timestamp.getNanos())) {
            throw new IllegalArgumentException(String.format("Timestamp is not valid. See proto definition for valid values. Seconds (%s) must be in range [-62,135,596,800, +253,402,300,799]. Nanos (%s) must be in range [0, +999,999,999].", seconds, nanos));
        }
        return timestamp;
    }

    public static Timestamp checkValid(Timestamp.Builder timestampBuilder) {
        return Timestamps.checkValid(timestampBuilder.build());
    }

    public static String toString(Timestamp timestamp) {
        Timestamps.checkValid(timestamp);
        long seconds = timestamp.getSeconds();
        int nanos = timestamp.getNanos();
        StringBuilder result = new StringBuilder();
        Date date = new Date(seconds * 1000L);
        result.append(timestampFormat.get().format(date));
        if (nanos != 0) {
            result.append(".");
            result.append(Timestamps.formatNanos(nanos));
        }
        result.append("Z");
        return result.toString();
    }

    public static Timestamp fromMillis(long milliseconds) {
        return Timestamps.normalizedTimestamp(milliseconds / 1000L, (int)(milliseconds % 1000L * 1000000L));
    }

    public static long toMillis(Timestamp timestamp) {
        Timestamps.checkValid(timestamp);
        return Timestamps.checkedAdd(Timestamps.checkedMultiply(timestamp.getSeconds(), 1000L), (long)timestamp.getNanos() / 1000000L);
    }

    public static Timestamp add(Timestamp start, Duration length) {
        Timestamps.checkValid(start);
        return Timestamps.normalizedTimestamp(Timestamps.checkedAdd(start.getSeconds(), length.getSeconds()), Timestamps.checkedAdd(start.getNanos(), length.getNanos()));
    }

    private static Timestamp normalizedTimestamp(long seconds, int nanos) {
        if ((long)nanos <= -1000000000L || (long)nanos >= 1000000000L) {
            seconds = Timestamps.checkedAdd(seconds, (long)nanos / 1000000000L);
            nanos = (int)((long)nanos % 1000000000L);
        }
        if (nanos < 0) {
            nanos = (int)((long)nanos + 1000000000L);
            seconds = Timestamps.checkedSubtract(seconds, 1L);
        }
        Timestamp timestamp = Timestamp.newBuilder().setSeconds(seconds).setNanos(nanos).build();
        return Timestamps.checkValid(timestamp);
    }

    private static long parseTimezoneOffset(String value) throws ParseException {
        int pos = value.indexOf(58);
        if (pos == -1) {
            throw new ParseException("Invalid offset value: " + value, 0);
        }
        String hours = value.substring(0, pos);
        String minutes = value.substring(pos + 1);
        return (Long.parseLong(hours) * 60L + Long.parseLong(minutes)) * 60L;
    }

    private static int parseNanos(String value) throws ParseException {
        int result = 0;
        for (int i = 0; i < 9; ++i) {
            result *= 10;
            if (i >= value.length()) continue;
            if (value.charAt(i) < '0' || value.charAt(i) > '9') {
                throw new ParseException("Invalid nanoseconds.", 0);
            }
            result += value.charAt(i) - 48;
        }
        return result;
    }

    private static String formatNanos(int nanos) {
        if ((long)nanos % 1000000L == 0L) {
            return String.format(Locale.ENGLISH, "%1$03d", (long)nanos / 1000000L);
        }
        if ((long)nanos % 1000L == 0L) {
            return String.format(Locale.ENGLISH, "%1$06d", (long)nanos / 1000L);
        }
        return String.format(Locale.ENGLISH, "%1$09d", nanos);
    }

    private static int checkedSubtract(long a, long b) {
        long result = a - b;
        Timestamps.checkNoOverflow(result == (long)((int)result), "checkedSubtract", a, b);
        return (int)result;
    }

    private static int checkedAdd(long a, long b) {
        long result = a + b;
        Timestamps.checkNoOverflow(result == (long)((int)result), "checkedAdd", a, b);
        return (int)result;
    }

    private static int checkedMultiply(long a, long b) {
        long result = a * b;
        Timestamps.checkNoOverflow(result == (long)((int)result), "checkedMultiply", a, b);
        return (int)result;
    }

    private static void checkNoOverflow(boolean condition, String methodName, long a, long b) {
        if (!condition) {
            throw new ArithmeticException("overflow: " + methodName + "(" + a + ", " + b + ")");
        }
    }
}

