package io.bidmachine.schema.adcom

import com.github.plokhotnyuk.jsoniter_scala.core.JsonValueCodec
import com.github.plokhotnyuk.jsoniter_scala.macros.{CodecMakerConfig, JsonCodecMaker}
import io.bidmachine.schema.adcom.App.Ext

import java.time.Instant

case class App(
  id: Option[String],
  name: Option[String],
  pub: Option[Publisher],
  domain: Option[String],
  cat: List[String],
  cattax: Option[CategoryTaxonomy],
  privpolicy: Option[Boolean],
  keywords: Option[String],
  bundle: Option[String],
  storeid: Option[String],
  storeurl: Option[String],
  ver: Option[String],
  paid: Option[Boolean],
  ext: Option[Ext]
)

object App {

  case class Ext(
    installTime: Option[Instant],
    firstLaunchTime: Option[Instant]
  )

  implicit val appCodec: JsonValueCodec[App] = JsonCodecMaker.make[App](CodecMakerConfig)
  implicit val appExtensionCodec: JsonValueCodec[Ext] = JsonCodecMaker.make[Ext](CodecMakerConfig)
}
