package io.bidmachine.schema.adcom

import com.github.plokhotnyuk.jsoniter_scala.core.JsonValueCodec
import com.github.plokhotnyuk.jsoniter_scala.macros.{CodecMakerConfig, JsonCodecMaker}
import io.bidmachine.schema.adcom.User.Ext

case class User(
  id: Option[String],
  buyeruid: Option[String],
  yob: Option[Int],
  gender: Option[String],
  keywords: Option[String],
  consent: Option[Consent],
  geo: Option[Geo],
  ext: Option[Ext]
)

object User {
  case class Ext(
    sessionduration: Option[Long],
    agency: Option[String],
    bundle: Option[String],
    imagency: Option[String],
    imbundle: Option[String],
    imd: Option[Int],
    imimd: Option[Int],
    imwp: Option[Float],
    wp: Option[Float],
    sc: Option[Int],
    retention: Option[Int]
  )

  object Ext {
    def empty: Ext = User.Ext(
      None,
      None,
      None,
      None,
      None,
      None,
      None,
      None,
      None,
      None,
      None
    )
  }

  implicit val userCodec: JsonValueCodec[User]         = JsonCodecMaker.make[User](CodecMakerConfig)
  implicit val userExtensionCodec: JsonValueCodec[Ext] = JsonCodecMaker.make[Ext](CodecMakerConfig)
}
