package io.bidmachine.schema.analytics

import com.github.plokhotnyuk.jsoniter_scala.core.JsonValueCodec
import com.github.plokhotnyuk.jsoniter_scala.macros.{CodecMakerConfig, JsonCodecMaker}
import io.bidmachine.schema.analytics.meta.EventMeta
import io.bidmachine.schema.rtb.{Bid, Request}

import java.time.Instant

case class BidRequestEvent(
  timestamp: Instant,
  meta: EventMeta,
  buyer: Buyer,
  seller: Seller,
  request: Request,
  bid: Option[Bid]
)

object BidRequestEvent {
  implicit val bidRequestCodec: JsonValueCodec[BidRequestEvent] = JsonCodecMaker.make[BidRequestEvent](CodecMakerConfig)
}
