package io.bidmachine.schema.analytics

import com.github.plokhotnyuk.jsoniter_scala.core.JsonValueCodec
import com.github.plokhotnyuk.jsoniter_scala.macros.{CodecMakerConfig, JsonCodecMaker}

import java.time.Instant

final case class WindowCounters(last_1h: Int, last_1d: Int, last_7d: Int)

object WindowCounters {
  implicit val windowCountersCodec: JsonValueCodec[WindowCounters] =
    JsonCodecMaker.make[WindowCounters](CodecMakerConfig)
}

final case class DomainCounters(domain: String, counters: WindowCounters)

object DomainCounters {
  implicit val domainCountersCodec: JsonValueCodec[DomainCounters] =
    JsonCodecMaker.make[DomainCounters](CodecMakerConfig)
}

final case class ImpsMetrics(
  interstitial: Vector[DomainCounters],
  rewarded: Vector[DomainCounters]
)

object ImpsMetrics {
  implicit val impsMetricsCodec: JsonValueCodec[ImpsMetrics] =
    JsonCodecMaker.make[ImpsMetrics](CodecMakerConfig)
}

final case class AdReqsMetrics(
  interstitial: WindowCounters,
  rewarded: WindowCounters
)

object AdReqsMetrics {
  implicit val adReqsMetricscodec: JsonValueCodec[AdReqsMetrics] =
    JsonCodecMaker.make[AdReqsMetrics](CodecMakerConfig)
}

final case class SessionDepthMetrics(
  imps: Option[ImpsMetrics],
  adreqs: Option[AdReqsMetrics]
)

object SessionDepthMetrics {
  implicit val sessionDepthMetricscodec: JsonValueCodec[SessionDepthMetrics] =
    JsonCodecMaker.make[SessionDepthMetrics](CodecMakerConfig)
}

final case class EcpmMetrics(
  firstPrices: Vector[Double],
  lastPrices: Vector[Double],
  count: Int
)

object EcpmMetrics {
  implicit val ecpmMetricsCodec: JsonValueCodec[EcpmMetrics] =
    JsonCodecMaker.make[EcpmMetrics](CodecMakerConfig)
}

final case class AdTypeMetrics(
  impressions: Int,
  adRequests: Int,
  bids: Int,
  wins: Int,
  losses: Int,
  lurls: Int,
  nurls: Int,
  cumulativeBidPrice: Double,
  cumulativeLurlPrice: Double,
  cumulativeNurlPrice: Double,
  ecpm: Option[EcpmMetrics],
  auctions: List[Auction],           // most recent 10 auctions
  adRequestTimestamps: List[Instant] // most recent 10 timestamps in millis
)

object AdTypeMetrics {
  implicit val adTypeMetricsCodec: JsonValueCodec[AdTypeMetrics] =
    JsonCodecMaker.make[AdTypeMetrics](CodecMakerConfig)
}

final case class SessionMetrics(
  sessionStart: Option[Long],
  lastActivity: Option[Long],
  interstitial: Option[AdTypeMetrics],
  rewarded: Option[AdTypeMetrics],
  banner: Option[AdTypeMetrics],
  isPurchaser: Boolean
)

object SessionMetrics {
  implicit val sessionCodec: JsonValueCodec[SessionMetrics] =
    JsonCodecMaker.make[SessionMetrics](CodecMakerConfig)
}

final case class Metrics(depth: SessionDepthMetrics, session: SessionMetrics)

object Metrics {
  implicit val metricsCodec: JsonValueCodec[Metrics] =
    JsonCodecMaker.make[Metrics](CodecMakerConfig)
}

final case class Auction(
  winnerBidderId: Long,
  losersBidderId: List[Long] // 50 values at most
)
