package io.bidmachine.schema.analytics

import com.github.plokhotnyuk.jsoniter_scala.core.JsonValueCodec
import com.github.plokhotnyuk.jsoniter_scala.macros.{CodecMakerConfig, JsonCodecMaker}
import io.bidmachine.schema.analytics.NumericPriceLevels.DoubleLevel

case class NumericPriceLevels(
  flr: DoubleLevel,
  price: DoubleLevel,
  clearPrice: Option[DoubleLevel]
)

object NumericPriceLevels {
  type DoubleLevel = Double
  implicit val numericPriceLevelsCodec: JsonValueCodec[NumericPriceLevels] =
    JsonCodecMaker.make[NumericPriceLevels](CodecMakerConfig)
}
