package io.bidmachine.schema.analytics

import java.time.Instant
import com.github.plokhotnyuk.jsoniter_scala.core.JsonValueCodec
import com.github.plokhotnyuk.jsoniter_scala.macros.{CodecMakerConfig, JsonCodecMaker}
import io.bidmachine.schema.analytics.NumericPriceLevels.DoubleLevel
import io.bidmachine.schema.analytics.PriceLevels.Level
import io.bidmachine.schema.analytics.TrackEvent.TrackEventExtension
import io.bidmachine.schema.analytics.meta.EventMeta
import io.bidmachine.schema.annotations.money
import io.bidmachine.schema.rtb.{Bid, Request}

case class TrackEvent(
  timestamp: Instant,
  meta: EventMeta,
  eventCode: Int,
  buyer: Buyer,
  seller: Seller,
  request: Request,
  bid: Bid,
  ext: TrackEventExtension
)

object TrackEvent {
  case class TrackEventExtension(
    latency: Option[Double],
    latencyLevel: String,
    trackingMethod: Option[Int],
    nurlResponseStatus: Option[String],
    burlResponseStatus: Option[String],
    extSegmentId: Option[Long],
    extPlacementId: Option[Long],
    sessionInterval: Option[Long],
    sessionIntervalLevel: Option[String],
    hbNetwork: Option[String],
    bmAdType: Option[String],
    lossReason: Option[Int],
    rawLossReason: Option[String],
    mraidDelay: Option[String],
    mraidZone: Option[String],
    mraidViewable: Option[Boolean],
    mraidDelayed: Option[Boolean],
    mraidRepeated: Option[Boolean],
    @money sellerIncome: Double,
    sellerIncomeLevel: Option[Level],
    sellerIncomeLevelV2: Option[DoubleLevel],
    exchangeFee: Double,
    importable: Boolean,
    lossSeatId: Option[String],
    lossPrice: Option[Double],
    lossPriceLevel: Option[DoubleLevel],
    minBidToWin: Option[Double],
    minBidToWinLevel: Option[DoubleLevel],
    errorCode: Option[String],
    errorActionCode: Option[String],
    errorFailedEventCode: Option[String],
    errorReason: Option[String],
    @money potentialSellerClearPrice: Option[Double], // price from auction-bid clearing price
  )
  implicit val trackEventCodec: JsonValueCodec[TrackEvent]                   =
    JsonCodecMaker.make[TrackEvent](CodecMakerConfig)
  implicit val trackEventExtensionCodec: JsonValueCodec[TrackEventExtension] =
    JsonCodecMaker.make[TrackEventExtension](CodecMakerConfig)
}
