package io.bidmachine.schema.jsoniter

import com.github.plokhotnyuk.jsoniter_scala.core.{JsonReader, JsonValueCodec, JsonWriter}
import enumeratum.values.{IntEnum, IntEnumEntry, StringEnum, StringEnumEntry}

trait JsoniterEnumInstances {

  implicit def jsoniterIntEnumCodec[A <: IntEnumEntry](implicit intEnum: IntEnum[A]): JsonValueCodec[A] =
    new JsonValueCodec[A] {
      override def decodeValue(in: JsonReader, default: A) = intEnum.withValue(in.readInt())

      override def encodeValue(x: A, out: JsonWriter): Unit = out.writeVal(x.value)

      override def nullValue = intEnum.values.head
    }

  implicit def jsoniterStringEnumCodec[A <: StringEnumEntry](implicit stringEnum: StringEnum[A]): JsonValueCodec[A] =
    new JsonValueCodec[A] {
      override def decodeValue(in: JsonReader, default: A) = stringEnum.withValue(in.readString(""))

      override def encodeValue(x: A, out: JsonWriter): Unit = out.writeVal(x.value)

      override def nullValue = stringEnum.values.head
    }
}

object JsoniterEnumInstances extends JsoniterEnumInstances
