package io.bidmachine.schema.rtb

import enumeratum.values.{IntEnum, IntEnumEntry}
import io.bidmachine.schema.jsoniter.JsoniterEnumInstances

sealed abstract class AuctionType(val value: Int) extends IntEnumEntry

object AuctionType extends IntEnum[AuctionType] with JsoniterEnumInstances {

  case object FirstPrice  extends AuctionType(1)
  case object SecondPrice extends AuctionType(2)

  val values = findValues

}
