package io.bidmachine.schema.rtb

import com.github.plokhotnyuk.jsoniter_scala.core.JsonValueCodec
import com.github.plokhotnyuk.jsoniter_scala.macros.{CodecMakerConfig, JsonCodecMaker}
import io.bidmachine.schema.adcom.Device
import io.bidmachine.schema.analytics.Metrics
import io.bidmachine.schema.annotations.money
import io.bidmachine.schema.rtb.ShortRequest.Ext.SupplyParameters

case class ShortRequest(
  id: String,
  @money flr: Double,
  placement: ShortPlacement,
  context: ShortContext,
  ext: ShortRequest.Ext
)

object ShortRequest {

  case class Ext(
    adRequestId: String,
    adt: Option[String],
    int: Option[String],
    dc: Option[String],
    calloutRound: Option[Int],
    calloutPolicy: Option[String],
    bidPrediction: Option[Int],
    sellerFlrPolicy: Option[String],
    bidderFlrPolicy: Option[String],
    @money flr: Double,
    sessionId: Option[String],
    mediationStackId: Option[String],
    bmIfv: Option[String],
    postbid: Option[Boolean],
    supplyParameters: Option[SupplyParameters],
    mediationBidRequestId: Option[String],
    metrics: Option[Metrics],
    hva: Option[Boolean],
    appHva: Option[Boolean],
    sourceRequestId: Option[String],
    originalFloor: Option[Double]
  )

  object Ext {
    case class SupplyParameters(
      customTargeting: Map[String, String],
      mediationMode: Option[String],
      originalAdType: Option[String],
      mediationSdkVersion: Option[String],
      mediationSdk: Option[String]
    )
  }

  implicit val requestExtCodec: JsonValueCodec[ShortRequest.Ext] =
    JsonCodecMaker.make[ShortRequest.Ext](CodecMakerConfig)
  implicit val requestCodec: JsonValueCodec[ShortRequest]        = JsonCodecMaker.make[ShortRequest](CodecMakerConfig)
}

case class ShortContext(app: ShortApp, device: Device, user: ShortUser)

object ShortContext {
  implicit val contextCodec: JsonValueCodec[ShortContext] = JsonCodecMaker.make[ShortContext](CodecMakerConfig)
}

case class ShortApp(
  name: Option[String],
  bundle: Option[String]
)

object ShortApp {
  implicit val appCodec: JsonValueCodec[ShortApp] = JsonCodecMaker.make[ShortApp](CodecMakerConfig)
}

case class ShortUser(
  ext: Option[ShortUser.Ext]
)

object ShortUser {

  case class Ext(
    sessionduration: Option[Long],
    retention: Option[Int],
    sc: Option[Int]
  )

  implicit val userCodec: JsonValueCodec[ShortUser]    = JsonCodecMaker.make[ShortUser](CodecMakerConfig)
  implicit val userExtensionCodec: JsonValueCodec[Ext] = JsonCodecMaker.make[Ext](CodecMakerConfig)
}

case class ShortPlacement(
  sdk: Option[String],
  sdkver: Option[String],
  reward: Option[Boolean],
  display: Option[ShortDisplayPlacement]
)

case class ShortDisplayPlacement(
  w: Option[Int],
  h: Option[Int]
)

object ShortPlacement {
  implicit val placementCodec: JsonValueCodec[ShortPlacement] = JsonCodecMaker.make[ShortPlacement](CodecMakerConfig)
}

object ShortDisplayPlacement {
  implicit val shortDisplayPlacementCodec: JsonValueCodec[ShortDisplayPlacement] = JsonCodecMaker.make[ShortDisplayPlacement](CodecMakerConfig)
}