package io.bidmachine.schema.adcom

import com.github.plokhotnyuk.jsoniter_scala.core.JsonValueCodec
import com.github.plokhotnyuk.jsoniter_scala.macros.{CodecMakerConfig, JsonCodecMaker}

case class DisplayPlacement(
  instl: Boolean,
  topframe: Boolean,
  clktype: Option[ClickType],
  mime: List[String],
  api: List[ApiFramework],
  w: Option[Int],
  h: Option[Int],
  unit: Option[SizeUnit],
  ext: DisplayPlacement.Ext
)

object DisplayPlacement {
  case class Ext(
    omidpv: Option[String],
    rtb2NativeVer: Option[String] // bid-request.imp[].native.ver from seller's request
  )

  implicit val displayPlacementCodec: JsonValueCodec[DisplayPlacement]        =
    JsonCodecMaker.make[DisplayPlacement](CodecMakerConfig)
  implicit val displayPlacementExtCodec: JsonValueCodec[DisplayPlacement.Ext] =
    JsonCodecMaker.make[DisplayPlacement.Ext](CodecMakerConfig)
}
