package io.bidmachine.schema.analytics.meta

import enumeratum.values.{StringEnum, StringEnumEntry}
import io.bidmachine.schema.jsoniter.JsoniterEnumInstances

sealed abstract class FeatureStatus(val value: String) extends StringEnumEntry

object FeatureStatus extends StringEnum[FeatureStatus] with JsoniterEnumInstances {

  case object On  extends FeatureStatus("on")
  case object Off extends FeatureStatus("off")

  val values = findValues
}
