package io.bidmachine.schema.jsoniter

import com.github.plokhotnyuk.jsoniter_scala.core.{JsonReader, JsonValueCodec, JsonWriter}
import enumeratum.values._

trait JsoniterEnumInstances {

  implicit def jsoniterIntEnumCodec[A <: IntEnumEntry](implicit intEnum: IntEnum[A]): JsonValueCodec[A] =
    new JsonValueCodec[A] {
      override def decodeValue(in: JsonReader, default: A): A = intEnum.withValue(in.readInt())

      override def encodeValue(x: A, out: JsonWriter): Unit = out.writeVal(x.value)

      override def nullValue: A = intEnum.values.head
    }

  implicit def jsoniterByteEnumCodec[A <: ByteEnumEntry](implicit byteEnum: ByteEnum[A]): JsonValueCodec[A] =
    new JsonValueCodec[A] {
      override def decodeValue(in: JsonReader, default: A): A = byteEnum.withValue(in.readByte())

      override def encodeValue(x: A, out: JsonWriter): Unit = out.writeVal(x.value)

      override def nullValue: A = byteEnum.values.head
    }

  implicit def jsoniterStringEnumCodec[A <: StringEnumEntry](implicit stringEnum: StringEnum[A]): JsonValueCodec[A] =
    new JsonValueCodec[A] {
      override def decodeValue(in: JsonReader, default: A): A = stringEnum.withValue(in.readString(""))

      override def encodeValue(x: A, out: JsonWriter): Unit = out.writeVal(x.value)

      override def nullValue: A = stringEnum.values.head
    }
}

object JsoniterEnumInstances extends JsoniterEnumInstances
