package io.bidmachine.schema.rtb

import enumeratum.values.{ByteEnum, ByteEnumEntry}
import io.bidmachine.schema.jsoniter.JsoniterEnumInstances

sealed abstract class BidAdType(val value: Byte) extends ByteEnumEntry

object BidAdType extends ByteEnum[BidAdType] with JsoniterEnumInstances {

  case object Unknown                  extends BidAdType(0)
  case object Banner                   extends BidAdType(1)
  case object Interstitial             extends BidAdType(2)
  case object SkippableVideo           extends BidAdType(3)
  case object NonSkippableVideo        extends BidAdType(4)
  case object Mrec                     extends BidAdType(5)
  case object Native                   extends BidAdType(6)
  case object NonSkippableInterstitial extends BidAdType(7)

  val values: IndexedSeq[BidAdType] = findValues

  val fromStringValue: String => BidAdType = {
    case "banner"                     => Banner
    case "mrec"                       => Mrec
    case "interstitial"               => Interstitial
    case "native"                     => Native
    case "skippable_video"            => SkippableVideo
    case "non_skippable_video"        => NonSkippableVideo
    case "non_skippable_interstitial" => NonSkippableInterstitial
    case _                            => Unknown
  }
}
