package io.bidmachine.schema.analytics

import com.github.plokhotnyuk.jsoniter_scala.core.JsonValueCodec
import com.github.plokhotnyuk.jsoniter_scala.macros.{CodecMakerConfig, JsonCodecMaker}
import io.bidmachine.schema.adcom.{ConnectionType, DeviceType, Geo}
import io.bidmachine.schema.analytics.meta.EventMeta

import java.time.Instant

case class InitRequestEvent(
  timestamp: Instant,
  id: String, // Unique Request Id (possible UUID)
  sourceId: String,
  bundle: String,
  os: Option[String],
  osv: String,
  sdk: String,
  sdkver: String,
  deviceType: Option[DeviceType],
  connectionType: Option[ConnectionType],
  geo: Option[Geo],
  appVersion: Option[String],
  ifa: Option[String],
  ifv: Option[String],
  bmIfv: Option[String],
  sessionId: Option[String],
  ip: Option[String],
  domain: String,
  displayManager: Option[List[InitDisplayManager]],
  meta: EventMeta,
  make: Option[String],
  model: Option[String],
  hwv: Option[String],
  initialDC: Option[String],
  routedDC: Option[String],
  installTime: Option[Instant],
  firstLaunchTime: Option[Instant],
  lastSessionDuration: Option[Long]
)

object InitRequestEvent {
  implicit val initSessionEventCodec: JsonValueCodec[InitRequestEvent] =
    JsonCodecMaker.make[InitRequestEvent](CodecMakerConfig)
}
