package io.bidmachine.schema.analytics

import com.github.plokhotnyuk.jsoniter_scala.core.JsonValueCodec
import com.github.plokhotnyuk.jsoniter_scala.macros.{CodecMakerConfig, JsonCodecMaker}

import java.time.Instant
import java.util.UUID

case class NonValidTrackingInfo(
  timestamp: Instant,
  eventId: UUID,
  event: Option[String],
  eventStatus: String,
  bidRequestId: Option[UUID] = None,
  timestampAuction: Option[Instant] = None,
  latencyLevel: Option[String] = None,
  sellerBidFloor: Option[Double] = None,
  bidFloor: Option[Double] = None,
  bidPrice: Option[Double] = None,
  clearPrice: Option[Double] = None,
  clearPriceLevel: Option[String] = None,
  exchangeFee: Option[Double] = None,
  sspIncome: Option[Double] = None,
  bidFloorLevel: Option[String] = None,
  bidPriceLevel: Option[String] = None,
  extSegmentId: Option[Long] = None,
  extPlacementId: Option[Long] = None,
  agencyId: Option[Long] = None,
  externalAgencyId: Option[Long] = None,
  bidderId: Option[Long] = None,
  // App
  appBundle: Option[String] = None,
  appId: Option[Long] = None,
  appIdRaw: Option[String] = None,
  appName: Option[String] = None,
  appVersion: Option[String] = None,
  // Site
  siteId: Option[String] = None,
  siteName: Option[String] = None,
  siteDomain: Option[String] = None,
  siteMobile: Option[Boolean] = None,
  country: Option[String] = None,
  deviceOs: Option[String] = None,
  deviceOsVersion: Option[String] = None,
  deviceIp: Option[String] = None,
  deviceIpV6: Option[String] = None,
  deviceConnectionType: Option[String] = None,
  deviceIfa: Option[String] = None,
  adType: Option[String] = None,
  adSize: Option[String] = None,
  publisherId: Option[String] = None,
  sdkName: Option[String] = None,    // mediation sdk name
  sdkVersion: Option[String] = None, // mediation sdk version
  displayManager: Option[String] = None,
  displayManagerVersion: Option[String] = None,
  w: Option[Long] = None,
  h: Option[Long] = None,
  adomain: Option[List[String]] = None,
  cid: Option[String] = None,
  crid: Option[String] = None,
  isNewSdkVersion: Option[Boolean] = None,
  externalCampaignImageId: Option[Long] = None,
  sellerId: Option[Long] = None,
  adNetwork: Option[Boolean] = None,
  adNetworkPlacementId: Option[String] = None,
  gdpr: Option[Boolean] = None,
  adSpaceId: Option[Long] = None,
  sessionNumber: Option[Long] = None,
  impressionNumber: Option[Long] = None,
  dcid: Option[String],
  trackingMethod: String,
  sessionIntervalLevel: Option[String] = None,
  sessionInterval: Option[Long] = None,
  hbNetwork: Option[String] = None,
  bmAdType: Option[String] = None,
  sourceId: Option[Long] = None,
  integrationType: Option[String],
  experiments: Option[List[String]],
  lossSeatId: Option[String],
  lossPrice: Option[Double],
  vpt: Option[Int],
  mediationStackId: Option[String],
  isContextDoubleEncoded: Option[Boolean],
  clickVideoPhase: Option[String],
  sourceRequestId: Option[String]
)

object NonValidTrackingInfo {

  implicit val nonValidTrackingInfoCodec: JsonValueCodec[NonValidTrackingInfo] =
    JsonCodecMaker.make[NonValidTrackingInfo](CodecMakerConfig)

}
