package io.bidmachine.schema.adcom

import enumeratum.values.{IntEnum, IntEnumEntry}
import io.bidmachine.schema.jsoniter.JsoniterEnumInstances

sealed abstract class ConnectionType(val value: Int) extends IntEnumEntry

object ConnectionType extends IntEnum[ConnectionType] with JsoniterEnumInstances {

  case object Unknown    extends ConnectionType(0)
  case object Ethernet   extends ConnectionType(1)
  case object Wifi       extends ConnectionType(2)
  case object Cellular   extends ConnectionType(3)
  case object Cellular2G extends ConnectionType(4)
  case object Cellular3G extends ConnectionType(5)
  case object Cellular4G extends ConnectionType(6)
  case object Cellular5G extends ConnectionType(7)

  val values = findValues
}
