package io.bidmachine.schema.adcom

import enumeratum.values.{IntEnum, IntEnumEntry}
import io.bidmachine.schema.jsoniter.JsoniterEnumInstances

sealed abstract class ExpandableDirection(val value: Int) extends IntEnumEntry

object ExpandableDirection extends IntEnum[ExpandableDirection] with JsoniterEnumInstances {

  case object Left       extends ExpandableDirection(1)
  case object Right      extends ExpandableDirection(2)
  case object Up         extends ExpandableDirection(3)
  case object Down       extends ExpandableDirection(4)
  case object FullScreen extends ExpandableDirection(5)

  val values = findValues
}
