package io.bidmachine.schema.analytics.rendering

import com.github.plokhotnyuk.jsoniter_scala.core.JsonValueCodec
import com.github.plokhotnyuk.jsoniter_scala.macros.{CodecMakerConfig, JsonCodecMaker}

case class PostbannerTemplate(
  templateNumbers: Option[List[String]],
  closeTime: Option[Double],
  closableView: Option[ClosableViewTemplate],
  countdown: Option[CountdownTemplate],
  r1: Option[Boolean]
)

object PostbannerTemplate {
  implicit val postbannerTemplateCodec: JsonValueCodec[PostbannerTemplate] =
    JsonCodecMaker.make[PostbannerTemplate](CodecMakerConfig)
}
