package io.bidmachine.schema.analytics.meta

import com.github.plokhotnyuk.jsoniter_scala.core.JsonValueCodec
import com.github.plokhotnyuk.jsoniter_scala.macros.{CodecMakerConfig, JsonCodecMaker}

case class EventMeta(
  sampling: Option[Sampling],
  experiments: List[DeprecatedExperiment],
  expLabels: List[String],
  features: List[Feature],
  isCanary: Boolean = false
)

object EventMeta {
  implicit val metaCodec: JsonValueCodec[EventMeta] = JsonCodecMaker.make[EventMeta](CodecMakerConfig)
}
