package io.bidmachine.schema.adcom

import com.github.plokhotnyuk.jsoniter_scala.core.JsonValueCodec
import com.github.plokhotnyuk.jsoniter_scala.macros.{CodecMakerConfig, JsonCodecMaker}
import io.bidmachine.schema.adcom

case class Device(
  `type`: Option[DeviceType],
  ua: Option[String],
  ifa: Option[String],
  lmt: Option[Boolean],
  make: Option[String],
  model: Option[String],
  os: Option[String],
  osv: Option[String],
  hwv: Option[String],
  h: Option[Int],
  w: Option[Int],
  ppi: Option[Int],
  pxratio: Option[Int],
  js: Option[Boolean],
  lang: Option[LanguageCode],
  ip: Option[IPv4],
  ipv6: Option[IPv6],
  xff: Option[String],
  iptr: Option[Boolean],
  carrier: Option[String],
  mccmnc: Option[String],
  mccmncsim: Option[String],
  contype: Option[ConnectionType],
  geofetch: Option[Boolean],
  geo: Option[Geo],
  ext: Device.Ext
)

object Device {
  case class Ext(
    access: Option[String],
    airplane: Option[Int],
    atts: Option[Int],
    batterylevel: Option[Double],
    batterysaver: Option[Int],
    charging: Option[Int],
    darkmode: Option[Int],
    devicename: Option[String],
    diskspace: Option[Int],
    dnd: Option[Int],
    headset: Option[Int],
    headsetname: Option[String],
    ifv: Option[String],
    inputlanguage: Option[List[String]],
    jailbreak: Option[Int],
    lastbootup: Option[Double],
    ringmute: Option[Int],
    screenbright: Option[Double],
    totaldisk: Option[Int],
    totalmem: Option[Long],
    cpuname: Option[String],
    cpuvendor: Option[String],
    gpuname: Option[String],
    time: Option[Long],
    timezone: Option[String],
    freemem: Option[Long],
    volumelevel: Option[Float],
    gpuvendor: Option[String]
  )

  object Ext {
    def empty: Ext = adcom.Device.Ext(
      None,
      None,
      None,
      None,
      None,
      None,
      None,
      None,
      None,
      None,
      None,
      None,
      None,
      None,
      None,
      None,
      None,
      None,
      None,
      None,
      None,
      None,
      None,
      None,
      None,
      None,
      None,
      None
    )
  }

  implicit val deviceCodec: JsonValueCodec[Device]        = JsonCodecMaker.make[Device](CodecMakerConfig)
  implicit val deviceExtCodec: JsonValueCodec[Device.Ext] = JsonCodecMaker.make[Device.Ext](CodecMakerConfig)
}
