package io.bidmachine.schema.adcom

import com.github.plokhotnyuk.jsoniter_scala.core.JsonValueCodec
import com.github.plokhotnyuk.jsoniter_scala.macros.{CodecMakerConfig, JsonCodecMaker}

case class VideoPlacement(
  delay: Option[Int],
  skip: Option[Int],
  skipmin: Option[Int],
  skipafter: Option[Int],
  api: List[ApiFramework],
  w: Option[Int],
  h: Option[Int],
  ext: VideoPlacement.Ext
)

object VideoPlacement {
  case class Ext(omidpv: Option[String])

  implicit val videoPlacementCodec: JsonValueCodec[VideoPlacement]        =
    JsonCodecMaker.make[VideoPlacement](CodecMakerConfig)
  implicit val videoPlacementExtCodec: JsonValueCodec[VideoPlacement.Ext] =
    JsonCodecMaker.make[VideoPlacement.Ext](CodecMakerConfig)
}
