package io.bidmachine.schema.analytics

import com.github.plokhotnyuk.jsoniter_scala.core.JsonValueCodec
import com.github.plokhotnyuk.jsoniter_scala.macros.{CodecMakerConfig, JsonCodecMaker}
import io.bidmachine.schema.analytics.meta.EventMeta
import io.bidmachine.schema.rtb.{Bid, Request}

import java.time.Instant

case class BidEvent(
  timestamp: Instant,
  meta: EventMeta,
  buyer: Buyer,
  seller: Seller,
  request: Request,
  bid: Bid
)

object BidEvent {
  implicit val bidEventCodec: JsonValueCodec[BidEvent] = JsonCodecMaker.make[BidEvent](CodecMakerConfig)
}
