package io.bidmachine.schema.adcom

import enumeratum.values.{IntEnum, IntEnumEntry}
import io.bidmachine.schema.jsoniter.JsoniterEnumInstances

sealed abstract class LocationType(val value: Int) extends IntEnumEntry

object LocationType extends IntEnum[LocationType] with JsoniterEnumInstances {

  case object GPS          extends LocationType(1)
  case object IP           extends LocationType(2)
  case object UserProvided extends LocationType(3)

  val values = findValues
}
