package io.bidmachine.schema.analytics

import com.github.plokhotnyuk.jsoniter_scala.core.JsonValueCodec
import com.github.plokhotnyuk.jsoniter_scala.macros.{CodecMakerConfig, JsonCodecMaker}
import io.bidmachine.schema.rtb.ShortRequest

import java.time.Instant

case class ShortBidEvent(
  timestamp: Instant,
  meta: ShortEventMeta,
  buyer: ShortBuyer,
  seller: ShortSeller,
  request: ShortRequest,
  bid: ShortBid
)

object ShortBidEvent {
  implicit val bidEventCodec: JsonValueCodec[ShortBidEvent] = JsonCodecMaker.make[ShortBidEvent](CodecMakerConfig)
}

case class ShortEventMeta(
  expLabels: List[String]
)

object ShortEventMeta {
  implicit val metaCodec: JsonValueCodec[ShortEventMeta] = JsonCodecMaker.make[ShortEventMeta](CodecMakerConfig)
}

case class ShortBuyer(
  id: Long,
  bidderId: Long,
  pretargetingId: Long
)

object ShortBuyer {
  implicit val buyerCodec: JsonValueCodec[ShortBuyer] = JsonCodecMaker.make[ShortBuyer](CodecMakerConfig)
}

case class ShortSeller(
  id: Long,
  sourceId: Long
)

object ShortSeller {
  implicit val sellerCodec: JsonValueCodec[ShortSeller] = JsonCodecMaker.make[ShortSeller](CodecMakerConfig)
}
