package io.bidmachine.schema.analytics

import com.github.plokhotnyuk.jsoniter_scala.core.JsonValueCodec
import com.github.plokhotnyuk.jsoniter_scala.macros.{CodecMakerConfig, JsonCodecMaker}
import io.bidmachine.schema.annotations.money
import io.bidmachine.schema.rtb.Bid.Ext.InvalidBidInfo
import io.bidmachine.schema.rtb.BidAdType

case class ShortBid(
  @money price: Double,
  media: ShortAd,
  ext: ShortBid.Ext
)

object ShortBid {
  case class Ext(
    auctionBidFloorSource: String,
    bidderBidFloorSource: String,
    status: BidStatus,
    @money clearPrice: Option[Double],
    @money sellerClearPrice: Option[Double],
    lossReason: Option[String],
    auctionSeq: Option[Int],
    cached: Boolean,
    @money netPrice: Option[Double],
    @money demandFee: Option[Double],
    obdPredictedProbability: Option[Double],
    obdFee: Option[Double],
    obdSellerClearingPrice: Option[Double],
    invalidBidInfo: Option[InvalidBidInfo],
    cachedLurlMillisPassed: Option[Long],
    apiFramework: Option[String],
    bidAdt: BidAdType = BidAdType.Unknown,
    @money cachedLurlPrice: Option[Double]
  )

  implicit val bidExtCodec: JsonValueCodec[ShortBid.Ext] = JsonCodecMaker.make[ShortBid.Ext](CodecMakerConfig)
  implicit val bidCodec: JsonValueCodec[ShortBid]        = JsonCodecMaker.make[ShortBid](CodecMakerConfig)
}

case class ShortAd(
  id: Option[String],
  adomain: List[String],
  bundle: Option[String],
  ext: ShortAd.Ext
)

object ShortAd {
  implicit val adCodec: JsonValueCodec[ShortAd] = JsonCodecMaker.make[ShortAd](CodecMakerConfig)

  case class Ext(
    cid: Option[String]
  )
}
