/*
 * Decompiled with CFR 0.152.
 */
package io.bidmachine.config.providers;

import io.bidmachine.config.exceptions.ConfigProviderException;
import io.bidmachine.config.providers.ArchiveConfigProvider;
import io.bidmachine.config.providers.ConfigProvider;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipConfigProvider
extends ArchiveConfigProvider
implements ConfigProvider {
    private static final Logger log = LoggerFactory.getLogger(ZipConfigProvider.class);
    private ZipFile arcFileHandle;
    private Map<String, ZipArchiveEntry> arcEntryMap;

    public ZipConfigProvider(String aArcPath) {
        super(aArcPath);
    }

    private void putEntryIntoMap(ZipArchiveEntry aEntry) {
        boolean isDir = aEntry.isDirectory();
        String name = aEntry.getName();
        if (isDir) {
            if (name.endsWith("/")) {
                name = name.substring(0, name.length() - 1);
            }
            this.putDirToMap(name);
        } else {
            int i = name.lastIndexOf(47);
            String dirName = name.substring(0, i);
            this.putDirToMap(dirName);
            String fileName = name.substring(i + 1);
            String fileFullPath = dirName + "/" + fileName;
            this.putIntoMap(this.fileFullPathMap, dirName, fileFullPath);
            this.arcEntryMap.put(fileFullPath, aEntry);
        }
    }

    @Override
    protected void scanArchive(String aArchiveFilename) {
        this.arcEntryMap = new TreeMap<String, ZipArchiveEntry>();
        log.info(String.format("Configuration will be loaded from %s", aArchiveFilename));
        if (!aArchiveFilename.endsWith("zip")) {
            throw new IllegalArgumentException(String.format("The file name must end with '.zip', but unfortunately it is %s", aArchiveFilename));
        }
        try {
            this.arcFileHandle = ((ZipFile.Builder)ZipFile.builder().setFile(aArchiveFilename)).setUseUnicodeExtraFields(true).get();
        }
        catch (IOException ex) {
            throw new ConfigProviderException(String.format("Error opening the zip file %s: %s", aArchiveFilename, ex.getMessage()), ex);
        }
        Enumeration entries = this.arcFileHandle.getEntries();
        while (entries.hasMoreElements()) {
            ZipArchiveEntry e = (ZipArchiveEntry)entries.nextElement();
            this.putEntryIntoMap(e);
        }
    }

    @Override
    public InputStream getInputStream(String aResourceName) {
        String resourceName = aResourceName;
        if (resourceName.startsWith("/")) {
            resourceName = resourceName.substring(1);
        }
        try {
            ZipArchiveEntry entry = this.arcEntryMap.get(resourceName);
            if (entry == null) {
                throw new ConfigProviderException(String.format("There are no entry named %s in the zip file %s", aResourceName, this.arcFile));
            }
            return new BufferedInputStream(this.arcFileHandle.getInputStream(entry), 131072);
        }
        catch (IOException ex) {
            throw new ConfigProviderException(String.format("Error reading the zip file %s: %s", this.arcFile, ex.getMessage()), ex);
        }
    }

    public String toString() {
        return String.format("ZipConfigProvider{arcFile='%s'}", this.arcFile);
    }
}

