/*
 * Decompiled with CFR 0.152.
 */
package io.bidmachine.mutators;

import io.bidmachine.data.FeatureRecord;
import io.bidmachine.mutators.BaseMutator;
import io.bidmachine.mutators.Mutator;
import io.bidmachine.mutators.MutatorException;
import io.bidmachine.utils.DateUtils;
import io.bidmachine.utils.MathUtils;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class AdRequestTimestampsMutator
extends BaseMutator
implements Mutator {
    public static final String[] TIMESTAMP_AD_TYPES = new String[]{"inter", "rewarded"};
    public static final String[] TIMESTAMP_FEATURES = new String[]{"f_ad_request_timestamp_1", "f_ad_request_timestamp_2", "f_ad_request_timestamp_3", "f_ad_request_timestamp_4", "f_ad_request_timestamp_5", "f_ad_request_timestamp_6", "f_ad_request_timestamp_7", "f_ad_request_timestamp_8", "f_ad_request_timestamp_9", "f_ad_request_timestamp_10", "f_ad_request_timestamp_11", "f_ad_request_timestamp_12", "f_ad_request_timestamp_13", "f_ad_request_timestamp_14", "f_ad_request_timestamp_15", "f_ad_request_timestamp_16", "f_ad_request_timestamp_17", "f_ad_request_timestamp_18", "f_ad_request_timestamp_19", "f_ad_request_timestamp_20", "f_ad_request_timestamps_len", "f_ad_request_timestamps_avg", "f_ad_request_timestamps_stddev"};

    public AdRequestTimestampsMutator(String aID) {
        super(aID);
    }

    @Override
    public Set<String> infoCalcFeatures() {
        return Set.of(TIMESTAMP_FEATURES);
    }

    @Override
    public Set<String> infoInputFeatures() {
        HashSet<String> features = new HashSet<String>();
        for (String adt : TIMESTAMP_AD_TYPES) {
            features.add("adRequestTimestamps_" + adt);
        }
        return features;
    }

    @Override
    public FeatureRecord mutate(FeatureRecord aFeatureRecord) throws MutatorException {
        Long sessionStartObject = (Long)aFeatureRecord.get("sessionStart");
        Instant tsInstant = DateUtils.getInstant(aFeatureRecord.get("ts"));
        if (sessionStartObject == null) {
            aFeatureRecord.stop("sessionStart is null, but it can't be");
            return aFeatureRecord;
        }
        if (tsInstant == null) {
            aFeatureRecord.stop("ts is null, but it can't be");
            return aFeatureRecord;
        }
        long sessionStart = sessionStartObject;
        long[] timestampsInter = (long[])aFeatureRecord.get("adRequestTimestamps_inter");
        long[] timestampsRewarded = (long[])aFeatureRecord.get("adRequestTimestamps_rewarded");
        if (timestampsInter == null) {
            timestampsInter = new long[]{};
        }
        if (timestampsRewarded == null) {
            timestampsRewarded = new long[]{};
        }
        int cntInterGreaterThanSessionStart = 0;
        int cntRewardedGreaterThanSessionStart = 0;
        for (long t : timestampsInter) {
            if (t <= sessionStart) continue;
            ++cntInterGreaterThanSessionStart;
        }
        for (long t : timestampsRewarded) {
            if (t <= sessionStart) continue;
            ++cntRewardedGreaterThanSessionStart;
        }
        long[] a = new long[1 + cntInterGreaterThanSessionStart + cntRewardedGreaterThanSessionStart];
        a[0] = tsInstant.toEpochMilli();
        int i = 1;
        for (long t : timestampsInter) {
            if (t <= sessionStart) continue;
            a[i++] = t;
        }
        for (long t : timestampsRewarded) {
            if (t <= sessionStart) continue;
            a[i++] = t;
        }
        Arrays.sort(a);
        long[] diff = a.length >= 2 ? new long[a.length - 1] : new long[]{};
        i = 0;
        for (int j = a.length - 1; j >= 1; --j) {
            diff[i++] = a[j] - a[j - 1];
        }
        i = 1;
        for (long d : diff) {
            aFeatureRecord.put("f_ad_request_timestamp_" + i++, d);
        }
        while (i <= 20) {
            aFeatureRecord.put("f_ad_request_timestamp_" + i++, null);
        }
        aFeatureRecord.put("f_ad_request_timestamps_len", diff.length);
        aFeatureRecord.put("f_ad_request_timestamps_avg", MathUtils.mean(diff));
        aFeatureRecord.put("f_ad_request_timestamps_stddev", MathUtils.std(diff));
        return aFeatureRecord;
    }
}

