/*
 * Decompiled with CFR 0.152.
 */
package io.bidmachine.mutators;

import io.bidmachine.data.DataFrame;
import io.bidmachine.data.DataFrameException;
import io.bidmachine.data.DataFrameProblem;
import io.bidmachine.data.FeatureRecord;
import io.bidmachine.mutators.BaseMutator;
import io.bidmachine.mutators.Mutator;
import io.bidmachine.mutators.MutatorException;
import io.bidmachine.utils.CollectionUtils;
import io.bidmachine.utils.Tuple;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LookupMutator
extends BaseMutator
implements Mutator {
    private final DataFrame dataframe;
    private final List<String> keyFields;
    private final List<String> addedFields;
    private final int overwritableStartPosition;
    private final boolean allowsNotFound;

    public LookupMutator(String aID, DataFrame aDf, List<String> aKeyFields, List<String> aAddedFieldsNotOverwritable, List<String> aAddedFieldsOverwritable, boolean aAllowsNotFound) {
        super(aID);
        boolean isNonOverwritableEmpty;
        this.dataframe = aDf;
        this.keyFields = aKeyFields;
        boolean isOverwritableEmpty = aAddedFieldsOverwritable == null || aAddedFieldsOverwritable.isEmpty();
        boolean bl = isNonOverwritableEmpty = aAddedFieldsNotOverwritable == null || aAddedFieldsNotOverwritable.isEmpty();
        if (isOverwritableEmpty && isNonOverwritableEmpty) {
            throw new IllegalArgumentException("Both overwritable and non-overwritable arrays cannot be empty at once");
        }
        if (isOverwritableEmpty) {
            this.addedFields = new ArrayList<String>(aAddedFieldsNotOverwritable);
            this.overwritableStartPosition = aAddedFieldsNotOverwritable.size();
        } else if (isNonOverwritableEmpty) {
            this.addedFields = new ArrayList<String>(aAddedFieldsOverwritable);
            this.overwritableStartPosition = 0;
        } else {
            this.overwritableStartPosition = aAddedFieldsNotOverwritable.size();
            this.addedFields = new ArrayList<String>(aAddedFieldsNotOverwritable);
            this.addedFields.addAll(aAddedFieldsOverwritable);
        }
        this.allowsNotFound = aAllowsNotFound;
    }

    Tuple<Map<String, Object>, String> lookup(FeatureRecord aFeatureRecord) throws MutatorException {
        String notFoundMessage = null;
        Object[] lookupFieldValues = aFeatureRecord.getObjectValues(this.keyFields);
        Map<String, Object> foundRow = null;
        try {
            foundRow = this.dataframe.getRowByKeyAsMapChecked(lookupFieldValues);
        }
        catch (DataFrameException ex) {
            if (ex.getProblem() != DataFrameProblem.SEARCH_NOT_FOUND) {
                throw new MutatorException(String.format("Lookup mutator %s can't perform a search due to an error with the indexed dataframe. %s", this.getId(), ex.getMessage()), ex);
            }
            notFoundMessage = String.format("cannot locate a row with %s", CollectionUtils.toStr(CollectionUtils.zip(this.keyFields.toArray(), lookupFieldValues)));
        }
        return new Tuple<Map<String, Object>, Object>(foundRow, notFoundMessage);
    }

    @Override
    public FeatureRecord mutate(FeatureRecord aFeatureRecord) throws MutatorException {
        Object[] lookupFieldValues;
        if (aFeatureRecord.isStopped()) {
            return aFeatureRecord;
        }
        try {
            lookupFieldValues = aFeatureRecord.getObjectValues(this.keyFields);
        }
        catch (Exception ex) {
            throw new MutatorException(String.format("Lookup mutator %s did not find some of the fields %s in the feature record. Original error message: %s", this.getId(), CollectionUtils.toStr(this.keyFields), ex.getMessage()));
        }
        Tuple<Map<String, Object>, String> foundResult = this.lookup(aFeatureRecord);
        if (foundResult.x != null) {
            for (int i = 0; i < this.addedFields.size(); ++i) {
                String addedField = this.addedFields.get(i);
                if (!((Map)foundResult.x).containsKey(addedField)) {
                    throw new MutatorException(String.format("Lookup mutator %s needs to get the field %s from the lookup-ed row, but there are no such field. List of fields in the lookup: %s ", this.getId(), this.addedFields.get(i), CollectionUtils.toStr(((Map)foundResult.x).keySet())));
                }
                if (i >= this.overwritableStartPosition) {
                    Object newValue = ((Map)foundResult.x).get(addedField);
                    aFeatureRecord.putOrOverwrite(addedField, newValue);
                    continue;
                }
                aFeatureRecord.put(addedField, ((Map)foundResult.x).get(addedField));
            }
        } else if (this.allowsNotFound) {
            for (int i = 0; i < this.addedFields.size(); ++i) {
                if (i >= this.overwritableStartPosition) {
                    aFeatureRecord.putIfNotExists(this.addedFields.get(i), null);
                    continue;
                }
                aFeatureRecord.put(this.addedFields.get(i), null);
            }
        } else {
            aFeatureRecord.stop(String.format("%s doesn't contain record for %s", this.getId(), CollectionUtils.toStr(lookupFieldValues)));
        }
        return aFeatureRecord;
    }

    @Override
    public Set<String> infoCalcFeatures() {
        return new HashSet<String>(this.addedFields);
    }

    @Override
    public Set<String> infoInputFeatures() {
        return new HashSet<String>(this.keyFields);
    }
}

