/*
 * Decompiled with CFR 0.152.
 */
package io.bidmachine.ml;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.bidmachine.ml.FloorSelectionStrategy;
import io.bidmachine.ml.MLParams;
import io.bidmachine.ml.PostprocessingParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MLParamsBuilder {
    private static final Logger log = LoggerFactory.getLogger(MLParamsBuilder.class);
    private static final MLParams defaultMLParams = new MLParams(FloorSelectionStrategy.SMART_WIN, PostprocessingParams.defaultValues());
    private static long cacheHits = 0L;
    private static final Cache<String, MLParams> lruCache = CacheBuilder.newBuilder().maximumSize(100L).build();

    public static MLParams getDefault() {
        return defaultMLParams;
    }

    public static MLParams get(String aJson) {
        MLParams result = (MLParams)lruCache.getIfPresent((Object)aJson);
        if (result == null) {
            result = MLParamsBuilder.makeFromJsonSafe(aJson);
            lruCache.put((Object)aJson, (Object)result);
        } else {
            ++cacheHits;
        }
        return result;
    }

    public static long getCacheHits() {
        return cacheHits;
    }

    static MLParams makeFromJsonUnsafe(String aJson) {
        Gson gson = new Gson();
        JsonObject jsonObject = (JsonObject)gson.fromJson(aJson, JsonObject.class);
        String strategyStr = jsonObject.get("floorSelectionStrategy").getAsString();
        FloorSelectionStrategy floorSelectionStrategy = FloorSelectionStrategy.valueOf(strategyStr);
        JsonObject postprocessingParamsJson = jsonObject.getAsJsonObject("postprocessingParams");
        PostprocessingParams postprocessingParams = (PostprocessingParams)gson.fromJson((JsonElement)postprocessingParamsJson, PostprocessingParams.class);
        return new MLParams(floorSelectionStrategy, postprocessingParams);
    }

    static MLParams makeFromJsonSafe(String aJson) {
        try {
            return MLParamsBuilder.makeFromJsonUnsafe(aJson);
        }
        catch (Exception ex) {
            log.error(String.format("Error parsing MLParams from %s: %s", aJson, ex.getMessage()), (Throwable)ex);
            return defaultMLParams;
        }
    }
}

