/*
 * Decompiled with CFR 0.152.
 */
package io.bidmachine.ml;

import io.bidmachine.ml.PostprocessingParams;
import io.bidmachine.utils.Tuple;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Postprocessing {
    private static final Logger log = LoggerFactory.getLogger(Postprocessing.class);

    public static double calcPlainWin(float[] aFloors, double[] aProbHasGoodBids, double[] probIsSpendNurl) {
        double maxProb = Double.MIN_VALUE;
        int maxIndex = -1;
        for (int i = 0; i < aProbHasGoodBids.length; ++i) {
            double prob = aProbHasGoodBids[i] * probIsSpendNurl[i];
            if (!(prob > maxProb)) continue;
            maxProb = prob;
            maxIndex = i;
        }
        return aFloors[maxIndex];
    }

    public static double calcReachWinProb(PostprocessingParams aParams, float[] aFloors, double[] probIsSpendNurl) {
        int n = probIsSpendNurl.length;
        double t = aParams.getMedProbThreshold();
        for (int i = 0; i < n; ++i) {
            if (!(probIsSpendNurl[i] >= t)) continue;
            return aFloors[i];
        }
        return aFloors[n >> 1];
    }

    public static double calcSmartReachWinProb(PostprocessingParams aParams, float[] aFloors, double[] probIsSpendNurl) {
        if (aParams.isFixSmooth()) {
            probIsSpendNurl = Postprocessing.rollingMean(probIsSpendNurl, aParams.getSmoothWindow());
        }
        if (aParams.isFixIncreasing()) {
            Postprocessing.makeIncreasing(probIsSpendNurl);
        }
        if (aParams.isFixBounds()) {
            Postprocessing.normalizeUpperBound(probIsSpendNurl);
        }
        double pLogDerivativeMinValue = aParams.getSmartReachProbDerivativeMinValue();
        double[] derivative = aParams.getSmartReachProbUseLogScaleDerivative() ? Postprocessing.calculateFirstDerivativeLogScale(aFloors, probIsSpendNurl) : Postprocessing.calculateFirstDerivative(aFloors, probIsSpendNurl);
        int indexOfMaxDerivative = Postprocessing.argmaxLast(derivative);
        double maxDerivative = derivative[indexOfMaxDerivative];
        double pLogDerivativeThreshold = aParams.getSmartReachProbDerivativeThreshold();
        if (aParams.getSmartReachProbUseRelativeThreshold()) {
            pLogDerivativeThreshold *= maxDerivative;
        }
        int indexOfRightmostAboveThreshold = Postprocessing.aboveThresholdLast(derivative, pLogDerivativeThreshold);
        if (pLogDerivativeThreshold < 0.0 || indexOfRightmostAboveThreshold < 0 || pLogDerivativeMinValue > 0.0 && maxDerivative < pLogDerivativeMinValue && (double)aFloors[indexOfMaxDerivative] > 1.0) {
            return Postprocessing.calcReachWinProb(aParams, aFloors, probIsSpendNurl);
        }
        return aFloors[indexOfRightmostAboveThreshold];
    }

    static double[] calculateFirstDerivative(float[] x, double[] y) {
        double[] derivative = new double[x.length];
        for (int i = 1; i < derivative.length - 1; ++i) {
            double dx = x[i + 1] - x[i - 1];
            double dy = y[i + 1] - y[i - 1];
            derivative[i] = dx > 1.0E-7 ? dy / dx : 0.0;
        }
        return derivative;
    }

    static double[] calculateFirstDerivativeLogScale(float[] x, double[] y) {
        double[] derivative = Postprocessing.calculateFirstDerivative(x, y);
        for (int i = 0; i < derivative.length; ++i) {
            int n = i;
            derivative[n] = derivative[n] * (double)x[i];
        }
        return derivative;
    }

    public static double calcPlainSpend(float[] aFloors, double[] aProbHasGoodBids, double[] probIsSpendNurl, double[] aSpend) {
        double maxExpectedSpend = Double.MIN_VALUE;
        int maxIndex = -1;
        for (int i = 0; i < aProbHasGoodBids.length; ++i) {
            double expectedSpend = aSpend[i] * aProbHasGoodBids[i] * probIsSpendNurl[i];
            if (!(expectedSpend > maxExpectedSpend)) continue;
            maxExpectedSpend = expectedSpend;
            maxIndex = i;
        }
        return aFloors[maxIndex];
    }

    public static double[] rollingMean(double[] a, int aWindow) {
        double[] result = new double[a.length];
        double windowSum = 0.0;
        for (int i = 0; i < a.length; ++i) {
            windowSum += a[i];
            if (i < aWindow - 1) {
                result[i] = a[i];
                continue;
            }
            result[i] = windowSum / (double)aWindow;
            windowSum -= a[i - aWindow + 1];
        }
        return result;
    }

    static void linspace(double[] a, double aMin, double aMax) {
        double step = (aMax - aMin) / (double)(a.length - 1);
        for (int i = 0; i < a.length; ++i) {
            a[i] = aMin + step * (double)i;
        }
    }

    static void makeIncreasing(double[] a) {
        double newMax;
        double oldMin = Postprocessing.findMin(a);
        double oldMax = Postprocessing.findMax(a);
        for (int i = 1; i < a.length; ++i) {
            a[i] = Math.max(a[i], a[i - 1]);
        }
        double newMin = Postprocessing.findMin(a);
        if (newMin == (newMax = Postprocessing.findMax(a))) {
            Postprocessing.linspace(a, oldMin, oldMax);
        }
    }

    static void makeDecreasing(double[] a) {
        double newMax;
        double oldMin = Postprocessing.findMin(a);
        double oldMax = Postprocessing.findMax(a);
        for (int i = 1; i < a.length; ++i) {
            a[i] = Math.min(a[i], a[i - 1]);
        }
        double newMin = Postprocessing.findMin(a);
        if (newMin == (newMax = Postprocessing.findMax(a))) {
            Postprocessing.linspace(a, oldMax, oldMin);
        }
    }

    static double findMax(double[] a) {
        if (a == null || a.length == 0) {
            throw new IllegalArgumentException("Array is empty or null");
        }
        double result = a[0];
        for (int i = 1; i < a.length; ++i) {
            if (!(a[i] > result)) continue;
            result = a[i];
        }
        return result;
    }

    private static double findMin(double[] a) {
        if (a == null || a.length == 0) {
            throw new IllegalArgumentException("Array is empty or null");
        }
        double result = a[0];
        for (int i = 1; i < a.length; ++i) {
            if (!(a[i] < result)) continue;
            result = a[i];
        }
        return result;
    }

    static void normalizeLowerBound(double[] a) {
        double minValue = Postprocessing.findMin(a);
        double maxValue = Postprocessing.findMax(a);
        double range = maxValue - minValue;
        if (range == 0.0) {
            return;
        }
        double scale = maxValue / range;
        for (int i = 0; i < a.length; ++i) {
            a[i] = (a[i] - minValue) * scale;
        }
    }

    static void normalizeUpperBound(double[] a) {
        double minValue = Postprocessing.findMin(a);
        double maxValue = Postprocessing.findMax(a);
        double range = maxValue - minValue;
        if (range == 0.0) {
            return;
        }
        double scale = (1.0 - minValue) / range;
        for (int i = 0; i < a.length; ++i) {
            a[i] = minValue + (a[i] - minValue) * scale;
        }
    }

    static float calcMedianArrayOverwrite(float[] a) {
        int n = a.length;
        if (n == 0) {
            throw new IllegalArgumentException("calcMedianArrayOverwrite: array of size 0 is not acceptable");
        }
        if (n == 1) {
            return a[0];
        }
        Arrays.sort(a);
        int mid = n / 2;
        double result = n % 2 == 0 ? (double)(a[mid - 1] + a[mid]) / 2.0 : (double)a[mid];
        return (float)result;
    }

    static double[] extractSubset(double[] a, boolean[] aMask, int aCountTrue) {
        double[] result = new double[aCountTrue];
        int j = 0;
        for (int i = 0; i < a.length; ++i) {
            if (!aMask[i]) continue;
            result[j++] = a[i];
        }
        return result;
    }

    static float[] extractSubset(float[] a, boolean[] aMask, int aCountTrue) {
        float[] result = new float[aCountTrue];
        int j = 0;
        for (int i = 0; i < a.length; ++i) {
            if (!aMask[i]) continue;
            result[j++] = a[i];
        }
        return result;
    }

    static int argmaxLast(double[] a) {
        int n = a.length;
        int resultIndex = n - 1;
        double maxValue = a[n - 1];
        for (int i = n - 2; i >= 0; --i) {
            if (!(a[i] > maxValue)) continue;
            resultIndex = i;
            maxValue = a[i];
        }
        return resultIndex;
    }

    static int aboveThresholdLast(double[] a, double threshold) {
        for (int i = a.length - 1; i >= 0; --i) {
            if (!(a[i] > threshold)) continue;
            return i;
        }
        return -1;
    }

    static int[] getTopKIndices(double[] a, int aTopK) {
        int n = a.length;
        if (n == 0) {
            throw new IllegalArgumentException("getTopKIndices: array of size 0 is not acceptable");
        }
        if (aTopK <= 0) {
            throw new IllegalArgumentException("getTopKIndices: aTopK must be > 0");
        }
        if (n < aTopK) {
            throw new IllegalArgumentException(String.format("Array is of size %d less than topk=%d", a.length, aTopK));
        }
        if (aTopK == 1) {
            return new int[]{Postprocessing.argmaxLast(a)};
        }
        Integer[] indices = new Integer[n];
        for (int i = 0; i < n; ++i) {
            indices[i] = i;
        }
        Arrays.sort(indices, (first, second) -> {
            int result = Double.compare(a[second], a[first]);
            if (result == 0) {
                result = first.compareTo((Integer)second);
            }
            return result;
        });
        int[] result = new int[aTopK];
        for (int i = 0; i < aTopK; ++i) {
            result[i] = indices[i];
        }
        return result;
    }

    private static float[] getValuesByIndex(float[] a, int[] aIndices) {
        float[] result = new float[aIndices.length];
        for (int i = 0; i < aIndices.length; ++i) {
            result[i] = a[aIndices[i]];
        }
        return result;
    }

    public static Tuple<Double, Double> calcOptimalFloors(float[] aFloors, double[] aIsBidPred, double[] aIsWinPred, double[] aSpendNurlPred, boolean aFixSmooth, boolean aFixIncreasing, boolean aFixBounds, int aSmoothWindow, int aTopK, double aBidProbThreshold, double aMedProbThreshold, double aFloorUpperBound) {
        float[] flrFiltered;
        double[] expectedSpendFiltered;
        double[] winRateFiltered;
        boolean v;
        int i;
        int n = aFloors.length;
        if (n != aIsBidPred.length || n != aIsWinPred.length || n != aSpendNurlPred.length) {
            throw new IllegalArgumentException("calcOptimalFloors: arrays of different lengths");
        }
        double[] isWinPred = Arrays.copyOf(aIsWinPred, aIsWinPred.length);
        double[] isBidPred = Arrays.copyOf(aIsBidPred, aIsBidPred.length);
        double[] spendNurlPred = Arrays.copyOf(aSpendNurlPred, aSpendNurlPred.length);
        if (aFixSmooth) {
            isWinPred = Postprocessing.rollingMean(isWinPred, aSmoothWindow);
            isBidPred = Postprocessing.rollingMean(isBidPred, aSmoothWindow);
            spendNurlPred = Postprocessing.rollingMean(spendNurlPred, aSmoothWindow);
        }
        if (aFixIncreasing) {
            Postprocessing.makeIncreasing(spendNurlPred);
            Postprocessing.makeIncreasing(isWinPred);
            Postprocessing.makeDecreasing(isBidPred);
        }
        if (aFixBounds) {
            Postprocessing.normalizeLowerBound(isBidPred);
            Postprocessing.normalizeUpperBound(isWinPred);
        }
        for (int i2 = 0; i2 < n; ++i2) {
            spendNurlPred[i2] = Math.max((double)aFloors[i2], spendNurlPred[i2]);
        }
        double[] aWinRate = new double[n];
        double[] aExpectedSpend = new double[n];
        for (int i3 = 0; i3 < n; ++i3) {
            aWinRate[i3] = isBidPred[i3] * isWinPred[i3];
            aExpectedSpend[i3] = aWinRate[i3] * spendNurlPred[i3];
        }
        boolean[] mask = new boolean[n];
        Arrays.fill(mask, true);
        int countTrue = n;
        boolean[] maskNext = new boolean[n];
        int countNext = 0;
        for (i = 0; i < n; ++i) {
            maskNext[i] = v = mask[i] & (double)aFloors[i] <= aFloorUpperBound;
            if (!v) continue;
            ++countNext;
        }
        if (countNext > 0) {
            mask = maskNext;
            countTrue = countNext;
            maskNext = new boolean[n];
            countNext = 0;
            for (i = 0; i < n; ++i) {
                maskNext[i] = v = mask[i] & isBidPred[i] >= aBidProbThreshold;
                if (!v) continue;
                ++countNext;
            }
            if (countNext > 0) {
                mask = maskNext;
                countTrue = countNext;
                maskNext = new boolean[n];
                countNext = 0;
                for (i = 0; i < n; ++i) {
                    maskNext[i] = v = mask[i] & isWinPred[i] >= aMedProbThreshold;
                    if (!v) continue;
                    ++countNext;
                }
                if (countNext > 0) {
                    mask = maskNext;
                    countTrue = countNext;
                }
            }
        }
        if (countTrue < aTopK || countTrue == n) {
            winRateFiltered = Arrays.copyOf(aWinRate, n);
            expectedSpendFiltered = Arrays.copyOf(aExpectedSpend, n);
            flrFiltered = Arrays.copyOf(aFloors, n);
        } else {
            winRateFiltered = Postprocessing.extractSubset(aWinRate, mask, countTrue);
            expectedSpendFiltered = Postprocessing.extractSubset(aExpectedSpend, mask, countTrue);
            flrFiltered = Postprocessing.extractSubset(aFloors, mask, countTrue);
        }
        int[] idxTopWinRate = Postprocessing.getTopKIndices(winRateFiltered, aTopK);
        float[] values = Postprocessing.getValuesByIndex(flrFiltered, idxTopWinRate);
        float minimal = Postprocessing.calcMedianArrayOverwrite(values);
        int[] idxTopSpend = Postprocessing.getTopKIndices(expectedSpendFiltered, aTopK);
        values = Postprocessing.getValuesByIndex(flrFiltered, idxTopSpend);
        float optimal = Math.max(Postprocessing.calcMedianArrayOverwrite(values), minimal);
        return new Tuple<Double, Double>(Double.valueOf(minimal), Double.valueOf(optimal));
    }

    public static double calcSmartWin(PostprocessingParams aParams, float[] aFloors, double[] aIsBidProb, double[] aIsWinProb, double[] aSpend) {
        Tuple<Double, Double> result = Postprocessing.calcOptimalFloors(aFloors, aIsBidProb, aIsWinProb, aSpend, aParams.isFixSmooth(), aParams.isFixIncreasing(), aParams.isFixBounds(), aParams.getSmoothWindow(), aParams.getTopK(), aParams.getBidProbThreshold(), aParams.getMedProbThreshold(), aParams.getFloorUpperBound());
        return (Double)result.x;
    }

    public static double calcSmartSpend(PostprocessingParams aParams, float[] aFloors, double[] aIsBidProb, double[] aIsWinProb, double[] aSpend) {
        Tuple<Double, Double> result = Postprocessing.calcOptimalFloors(aFloors, aIsBidProb, aIsWinProb, aSpend, aParams.isFixSmooth(), aParams.isFixIncreasing(), aParams.isFixBounds(), aParams.getSmoothWindow(), aParams.getTopK(), aParams.getBidProbThreshold(), aParams.getMedProbThreshold(), aParams.getFloorUpperBound());
        return (Double)result.y;
    }

    public static double calcMiddleSmartSpendSmartWin(PostprocessingParams aParams, float[] aFloors, double[] aIsBidProb, double[] aIsWinProb, double[] aSpend) {
        Tuple<Double, Double> result = Postprocessing.calcOptimalFloors(aFloors, aIsBidProb, aIsWinProb, aSpend, aParams.isFixSmooth(), aParams.isFixIncreasing(), aParams.isFixBounds(), aParams.getSmoothWindow(), aParams.getTopK(), aParams.getBidProbThreshold(), aParams.getMedProbThreshold(), aParams.getFloorUpperBound());
        return ((Double)result.x + (Double)result.y) / 2.0;
    }

    public static double applyOriginalFloorFix(double aPredictedValue, PostprocessingParams aParams, double aOriginalFloor) {
        if (!Double.isNaN(aOriginalFloor) && aOriginalFloor > 0.0 && aParams.isNotLessThanOriginalFloor()) {
            double originalFloorScaled = aOriginalFloor * aParams.getOriginalFloorMultiplier();
            return Math.max(aPredictedValue, originalFloorScaled);
        }
        return aPredictedValue;
    }

    public static double calcEcpm(PostprocessingParams aParams, double aPredictedEcpm) {
        return aPredictedEcpm * aParams.getEcpmMultiplier();
    }
}

