/*
 * Decompiled with CFR 0.152.
 */
package io.bidmachine.mutators;

import io.bidmachine.data.FeatureRecord;
import io.bidmachine.mutators.BaseMutator;
import io.bidmachine.mutators.Mutator;
import io.bidmachine.utils.DateUtils;
import io.bidmachine.utils.StringUtils;
import io.bidmachine.utils.TimeUtils;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class CommonMutator
extends BaseMutator
implements Mutator {
    public static final String[][] BID_DENSITY_SUM_INT = new String[][]{{"bid_count_sess", "bid_count_inter_sess", "bid_count_rewarded_sess"}, {"bid_win_count_sess", "bid_win_count_inter_sess", "bid_win_count_rewarded_sess"}, {"bid_loss_count_sess", "bid_loss_count_inter_sess", "bid_loss_count_rewarded_sess"}, {"lurl_count_sess", "lurl_count_inter_sess", "lurl_count_rewarded_sess"}, {"nurl_count_sess", "nurl_count_inter_sess", "nurl_count_rewarded_sess"}};
    public static final String[][] BID_DENSITY_SUM_DOUBLE = new String[][]{{"nurl_cumsum_spend_sess", "nurl_cumsum_spend_inter_sess", "nurl_cumsum_spend_rewarded_sess"}, {"lurl_cumsum_lossPrice_sess", "lurl_cumsum_lossPrice_inter_sess", "lurl_cumsum_lossPrice_rewarded_sess"}, {"bid_win_cumsum_clearPrice_sess", "bid_win_cumsum_clearPrice_inter_sess", "bid_win_cumsum_clearPrice_rewarded_sess"}};
    public static final String[][] BID_DENSITY_DIV = new String[][]{{"bid_win_avg_clearPrice_sess", "bid_win_cumsum_clearPrice_sess", "bid_win_count_sess"}, {"lurl_avg_lossPrice_sess", "lurl_cumsum_lossPrice_sess", "lurl_count_sess"}, {"nurl_avg_spend_sess", "nurl_cumsum_spend_sess", "nurl_count_sess"}, {"bid_win_avg_clearPrice_inter_sess", "bid_win_cumsum_clearPrice_inter_sess", "bid_win_count_inter_sess"}, {"lurl_avg_lossPrice_inter_sess", "lurl_cumsum_lossPrice_inter_sess", "lurl_count_inter_sess"}, {"nurl_avg_spend_inter_sess", "nurl_cumsum_spend_inter_sess", "nurl_count_inter_sess"}, {"bid_win_avg_clearPrice_rewarded_sess", "bid_win_cumsum_clearPrice_rewarded_sess", "bid_win_count_rewarded_sess"}, {"lurl_avg_lossPrice_rewarded_sess", "lurl_cumsum_lossPrice_rewarded_sess", "lurl_count_rewarded_sess"}, {"nurl_avg_spend_rewarded_sess", "nurl_cumsum_spend_rewarded_sess", "nurl_count_rewarded_sess"}};
    public static final String[][] RATIO_FEATURES_INT_INT = new String[][]{{"nurl_win_ratio_inter_sess", "nurl_count_inter_sess", "bid_win_count_inter_sess"}, {"nurl_bid_ratio_inter_sess", "nurl_count_inter_sess", "bid_count_inter_sess"}, {"win_bid_ratio_inter_sess", "bid_win_count_inter_sess", "bid_count_inter_sess"}, {"nurl_ad_request_ratio_inter_sess", "nurl_count_inter_sess", "session_depth_inter"}, {"win_ad_request_ratio_inter_sess", "bid_win_count_inter_sess", "session_depth_inter"}, {"bid_ad_request_ratio_inter_sess", "bid_count_inter_sess", "session_depth_inter"}, {"nurl_win_ratio_rewarded_sess", "nurl_count_rewarded_sess", "bid_win_count_rewarded_sess"}, {"nurl_bid_ratio_rewarded_sess", "nurl_count_rewarded_sess", "bid_count_rewarded_sess"}, {"win_bid_ratio_rewarded_sess", "bid_win_count_rewarded_sess", "bid_count_rewarded_sess"}, {"nurl_ad_request_ratio_rewarded_sess", "nurl_count_rewarded_sess", "session_depth_rewarded"}, {"win_ad_request_ratio_rewarded_sess", "bid_win_count_rewarded_sess", "session_depth_rewarded"}, {"bid_ad_request_ratio_rewarded_sess", "bid_count_rewarded_sess", "session_depth_rewarded"}};
    public static final String[][] RATIO_FEATURES_INT_DOUBLE = new String[][]{{"ad_requests_per_ms_inter_sess", "session_depth_inter", "session_duration"}, {"bids_per_ms_inter_sess", "bid_count_inter_sess", "session_duration"}, {"wins_per_ms_inter_sess", "bid_win_count_inter_sess", "session_duration"}, {"ad_requests_per_ms_rewarded_sess", "session_depth_rewarded", "session_duration"}, {"bids_per_ms_rewarded_sess", "bid_count_rewarded_sess", "session_duration"}, {"wins_per_ms_rewarded_sess", "bid_win_count_rewarded_sess", "session_duration"}};

    @Override
    public Set<String> infoCalcFeatures() {
        HashSet<String> features = new HashSet<String>();
        for (String[] keys : BID_DENSITY_SUM_INT) {
            features.add(keys[0]);
        }
        for (String[] keys : BID_DENSITY_SUM_DOUBLE) {
            features.add(keys[0]);
        }
        for (String[] keys : BID_DENSITY_DIV) {
            features.add(keys[0]);
        }
        for (String[] keys : RATIO_FEATURES_INT_INT) {
            features.add(keys[0]);
        }
        for (String[] keys : RATIO_FEATURES_INT_DOUBLE) {
            features.add(keys[0]);
        }
        features.add("session_duration");
        features.add("seconds_since_last_active");
        features.add("is_ifa");
        return features;
    }

    @Override
    public Set<String> infoInputFeatures() {
        HashSet<String> features = new HashSet<String>();
        for (String[] keys : BID_DENSITY_SUM_INT) {
            features.add(keys[1]);
            features.add(keys[2]);
        }
        for (String[] keys : BID_DENSITY_SUM_DOUBLE) {
            features.add(keys[1]);
            features.add(keys[2]);
        }
        for (String[] keys : BID_DENSITY_DIV) {
            features.add(keys[1]);
            features.add(keys[2]);
        }
        features.add("country");
        features.add("region");
        features.add("model");
        features.add("make");
        features.add("inputlanguage");
        features.add("contype");
        features.add("session_depth_inter");
        features.add("session_impressions_inter");
        features.add("session_depth_rewarded");
        features.add("session_impressions_rewarded");
        features.add("originalFloor");
        features.add("sessionStart");
        features.add("lastActivity");
        return features;
    }

    public CommonMutator(String aID) {
        super(aID);
    }

    @Override
    public FeatureRecord mutate(FeatureRecord aFeatureRecord) {
        Object object;
        Object object2;
        Instant tsNow;
        if (aFeatureRecord.isStopped()) {
            return aFeatureRecord;
        }
        if (!aFeatureRecord.containsKey("ts")) {
            tsNow = Instant.now();
            aFeatureRecord.put("ts", tsNow);
        } else {
            tsNow = DateUtils.getInstant(aFeatureRecord.get("ts"));
        }
        String country = (String)aFeatureRecord.get("country");
        String region = (String)aFeatureRecord.get("region");
        String city = (String)aFeatureRecord.get("city");
        if (StringUtils.isNullOrEmptyOrSpace(country)) {
            country = null;
            aFeatureRecord.overwrite("country", null);
        }
        if (StringUtils.isNullOrEmptyOrSpace(region)) {
            region = null;
            aFeatureRecord.overwrite("region", null);
        }
        if (StringUtils.isNullOrEmptyOrSpace(city)) {
            aFeatureRecord.overwrite("city", null);
        }
        if ("US".equals(country) && region != null) {
            aFeatureRecord.overwrite("region", region.toUpperCase());
        }
        if (aFeatureRecord.containsKey("model")) {
            String string = StringUtils.lowercase((String)aFeatureRecord.get("model"));
            aFeatureRecord.overwrite("model", string);
        }
        if (aFeatureRecord.containsKey("make")) {
            String string = StringUtils.lowercase((String)aFeatureRecord.get("make"));
            aFeatureRecord.overwrite("make", string);
        }
        if (aFeatureRecord.containsKey("inputlanguage") && (object2 = aFeatureRecord.get("inputlanguage")) != null && !(object2 instanceof String)) {
            if (object2 instanceof String[]) {
                Object[] array = (String[])object2;
                Arrays.sort(array);
                aFeatureRecord.overwrite("inputlanguage", String.join((CharSequence)";", (CharSequence[])array));
            } else if (object2 instanceof Collection) {
                Collection collection = (Collection)object2;
                Object[] array = collection.toArray(new String[0]);
                Arrays.sort(array);
                aFeatureRecord.overwrite("inputlanguage", String.join((CharSequence)";", (CharSequence[])array));
            } else {
                aFeatureRecord.stop("inputlanguage has a bad value: must be a string, String[] or Collection<String>");
                return aFeatureRecord;
            }
        }
        if (aFeatureRecord.containsKey("contype") && (object = aFeatureRecord.get("contype")) == null) {
            aFeatureRecord.overwrite("contype", -1);
        }
        for (String[] keys : BID_DENSITY_SUM_INT) {
            CommonMutator.addSumFieldInt(aFeatureRecord, keys[0], keys[1], keys[2]);
        }
        for (String[] keys : BID_DENSITY_SUM_DOUBLE) {
            CommonMutator.addSumFieldDouble(aFeatureRecord, keys[0], keys[1], keys[2]);
        }
        for (String[] keys : BID_DENSITY_DIV) {
            CommonMutator.addDivField(aFeatureRecord, keys[0], keys[1], keys[2]);
        }
        Object object3 = aFeatureRecord.get("sessionStart");
        long sessionStart = object3 == null ? tsNow.toEpochMilli() : ((Long)object3).longValue();
        double sessionDuration = Math.max(0.0, TimeUtils.secondsSince(sessionStart, tsNow));
        aFeatureRecord.put("session_duration", sessionDuration);
        Object lastActivityObject = aFeatureRecord.get("lastActivity");
        if (lastActivityObject == null) {
            aFeatureRecord.put("seconds_since_last_active", null);
        } else {
            double secondsSinceLastActive = TimeUtils.secondsSince((Long)lastActivityObject, tsNow);
            aFeatureRecord.put("seconds_since_last_active", secondsSinceLastActive);
        }
        CommonMutator.setIntegerNullToZero(aFeatureRecord, "session_depth_inter");
        CommonMutator.setIntegerNullToZero(aFeatureRecord, "session_impressions_inter");
        CommonMutator.setIntegerNullToZero(aFeatureRecord, "session_depth_rewarded");
        CommonMutator.setIntegerNullToZero(aFeatureRecord, "session_impressions_rewarded");
        for (String[] keys : RATIO_FEATURES_INT_INT) {
            CommonMutator.addDivFieldIntInt(aFeatureRecord, keys[0], keys[1], keys[2]);
        }
        for (String[] keys : RATIO_FEATURES_INT_DOUBLE) {
            CommonMutator.addDivFieldIntDouble(aFeatureRecord, keys[0], keys[1], keys[2]);
        }
        CommonMutator.setDoubleNullToZero(aFeatureRecord, "originalFloor");
        String ifa = (String)aFeatureRecord.get("ifa");
        aFeatureRecord.put("is_ifa", StringUtils.isUserIdEmpty(ifa) ? 0 : 1);
        return aFeatureRecord;
    }

    private static double setDoubleNullToZero(FeatureRecord aFr, String aField) {
        Object v = aFr.get(aField);
        if (v == null) {
            aFr.overwrite(aField, 0.0);
            return 0.0;
        }
        Double dv = (Double)v;
        if (dv.isNaN()) {
            aFr.overwrite(aField, 0.0);
            return 0.0;
        }
        return dv;
    }

    private static int setIntegerNullToZero(FeatureRecord aFr, String aField) {
        Integer v = (Integer)aFr.get(aField);
        if (v == null) {
            aFr.overwrite(aField, 0);
            return 0;
        }
        return v;
    }

    private static long setLongNullToZero(FeatureRecord aFr, String aField) {
        Long v = (Long)aFr.get(aField);
        if (v == null) {
            aFr.overwrite(aField, 0L);
            return 0L;
        }
        return v;
    }

    private static void addSumFieldInt(FeatureRecord aFr, String aSumField, String aField1, String aField2) {
        Integer value1 = CommonMutator.setIntegerNullToZero(aFr, aField1);
        Integer value2 = CommonMutator.setIntegerNullToZero(aFr, aField2);
        aFr.put(aSumField, value1 + value2);
    }

    private static void addSumFieldDouble(FeatureRecord aFr, String aSumField, String aField1, String aField2) {
        Double value1 = CommonMutator.setDoubleNullToZero(aFr, aField1);
        Double value2 = CommonMutator.setDoubleNullToZero(aFr, aField2);
        aFr.put(aSumField, value1 + value2);
    }

    private static void addDivField(FeatureRecord aFr, String aNewField, String aNominator, String aDenominator) {
        int denominator = CommonMutator.setIntegerNullToZero(aFr, aDenominator);
        double nominator = CommonMutator.setDoubleNullToZero(aFr, aNominator);
        double newValue = denominator != 0 ? nominator / (double)denominator : 0.0;
        aFr.put(aNewField, newValue);
    }

    private static void addDivFieldIntInt(FeatureRecord aFr, String aNewField, String aNominator, String aDenominator) {
        int denominator = (Integer)aFr.get(aDenominator);
        int nominator = (Integer)aFr.get(aNominator);
        double newValue = denominator != 0 ? ((double)nominator + 0.0) / (double)denominator : 0.0;
        aFr.put(aNewField, newValue);
    }

    private static void addDivFieldIntDouble(FeatureRecord aFr, String aNewField, String aNominator, String aDenominator) {
        int nominator = (Integer)aFr.get(aNominator);
        double denominator = (Double)aFr.get(aDenominator);
        double newValue = denominator != 0.0 ? (double)nominator / denominator : 0.0;
        aFr.put(aNewField, newValue);
    }
}

