/*
 * Decompiled with CFR 0.152.
 */
package io.bidmachine.mutators;

import io.bidmachine.data.FeatureRecord;
import io.bidmachine.mutators.BaseMutator;
import io.bidmachine.mutators.Mutator;
import io.bidmachine.mutators.MutatorException;
import java.util.HashSet;
import java.util.Set;

public class TypeMutator
extends BaseMutator
implements Mutator {
    private static final String NULL_CONSTANT = "__NULL__";
    private final Iterable<String> catFeatures;
    private final Iterable<String> contFeatures;

    public TypeMutator(String aID, Iterable<String> aCatFeatures, Iterable<String> aContFeatures) {
        super(aID);
        this.catFeatures = aCatFeatures;
        this.contFeatures = aContFeatures;
    }

    @Override
    public FeatureRecord mutate(FeatureRecord aFeatureRecord) throws MutatorException {
        Object v;
        if (aFeatureRecord.isStopped()) {
            return aFeatureRecord;
        }
        for (String f : this.catFeatures) {
            v = aFeatureRecord.get(f);
            if (v == null) {
                aFeatureRecord.overwrite(f, NULL_CONSTANT);
                continue;
            }
            if (v instanceof String) {
                if (!((String)v).trim().isEmpty()) continue;
                aFeatureRecord.overwrite(f, NULL_CONSTANT);
                continue;
            }
            aFeatureRecord.overwrite(f, v.toString());
        }
        for (String f : this.contFeatures) {
            v = aFeatureRecord.get(f);
            if (v == null) {
                aFeatureRecord.overwrite(f, Float.valueOf(Float.NaN));
                continue;
            }
            if (v instanceof Float) continue;
            if (v instanceof Number) {
                aFeatureRecord.overwrite(f, Float.valueOf(((Number)v).floatValue()));
                continue;
            }
            throw new MutatorException(String.format("Cannot convert to float a non-numeric feature: %s with value %s", f, v));
        }
        return aFeatureRecord;
    }

    @Override
    public Set<String> infoCalcFeatures() {
        return new HashSet<String>();
    }

    @Override
    public Set<String> infoInputFeatures() {
        return new HashSet<String>();
    }
}

