/*
 * Decompiled with CFR 0.152.
 */
package io.bidmachine.config.data;

import com.google.gson.annotations.Expose;
import io.bidmachine.config.data.DataTypeEnum;
import io.bidmachine.config.data.FieldConfig;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SchemaConfig {
    private String[] key;
    private List<FieldConfig> fields;
    @Expose(serialize=false)
    private Map<String, Integer> indexFieldPos;
    @Expose(serialize=false)
    private Map<String, FieldConfig> mapNameToConfig;
    @Expose(serialize=false)
    private Map<String, Integer> mapNameToIndex;
    @Expose(serialize=false)
    private String[] valueFields;

    public SchemaConfig() {
    }

    public SchemaConfig(String[] aKey, List<FieldConfig> aFields) {
        this.key = aKey;
        this.fields = aFields;
    }

    public String[] getValueFields() {
        if (this.valueFields == null) {
            HashSet<String> keysSet = new HashSet<String>(Arrays.asList(this.key));
            String[] result = new String[this.fields.size() - this.key.length];
            int i = 0;
            for (FieldConfig field : this.fields) {
                String fn = field.getName();
                if (keysSet.contains(fn)) continue;
                result[i++] = fn;
            }
            this.valueFields = result;
        }
        return this.valueFields;
    }

    public List<FieldConfig> getFieldConfigs() {
        return this.fields;
    }

    public String[] getKey() {
        return this.key;
    }

    private Map<String, FieldConfig> buildMapNameToConfig() {
        HashMap<String, FieldConfig> result = new HashMap<String, FieldConfig>();
        if (this.fields != null) {
            for (FieldConfig fc : this.fields) {
                result.put(fc.getName(), fc);
            }
        }
        return result;
    }

    public FieldConfig getFieldConfig(String aFieldName) {
        if (this.mapNameToConfig == null) {
            this.mapNameToConfig = this.buildMapNameToConfig();
        }
        return this.mapNameToConfig.get(aFieldName);
    }

    private Map<String, Integer> buildMapNameToIndex() {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        if (this.fields != null) {
            for (int i = 0; i < this.fields.size(); ++i) {
                FieldConfig fc = this.fields.get(i);
                result.put(fc.getName(), i);
            }
        }
        return result;
    }

    public int getFieldIndex(String aFieldName) {
        if (this.mapNameToIndex == null) {
            this.mapNameToIndex = this.buildMapNameToIndex();
        }
        return this.mapNameToIndex.get(aFieldName);
    }

    public boolean fieldExists(String aColumnName, DataTypeEnum aFieldType) {
        FieldConfig fc;
        if (this.mapNameToConfig == null) {
            this.mapNameToConfig = this.buildMapNameToConfig();
        }
        if ((fc = this.mapNameToConfig.get(aColumnName)) == null) {
            return false;
        }
        return fc.getType() == aFieldType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaConfig that = (SchemaConfig)o;
        return Arrays.equals(this.key, that.key) && Objects.equals(this.fields, that.fields);
    }

    public int hashCode() {
        int result = Objects.hash(this.fields);
        result = 31 * result + Arrays.hashCode(this.key);
        return result;
    }
}

