/*
 * Decompiled with CFR 0.152.
 */
package io.bidmachine.config.providers;

import io.bidmachine.config.exceptions.ConfigProviderException;
import io.bidmachine.config.providers.ConfigProvider;
import io.bidmachine.utils.PathUtils;
import io.bidmachine.utils.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ArchiveConfigProvider
implements ConfigProvider {
    protected static final String REGEX_BUNDLE = "bundle_\\d{8}_\\d{6}\\.(zip|7z)";
    protected static final Logger log = LoggerFactory.getLogger(ArchiveConfigProvider.class);
    protected static final String INTERNAL_SLASH = "/";
    protected final String arcFile;
    protected final TreeMap<String, TreeSet<String>> dirFullPathMap = new TreeMap();
    protected final TreeMap<String, TreeSet<String>> fileFullPathMap = new TreeMap();

    protected void putIntoMap(TreeMap<String, TreeSet<String>> aMap, String aKey, String aValue) {
        aMap.computeIfAbsent(aKey, x -> new TreeSet());
        aMap.get(aKey).add(aValue);
    }

    protected void putDirToMap(String aDirName) {
        if (aDirName.endsWith(INTERNAL_SLASH)) {
            throw new IllegalArgumentException("Dir name should not end with /");
        }
        String[] parts = aDirName.split(INTERNAL_SLASH);
        Object parent = "";
        for (int i = 0; i < parts.length; ++i) {
            String child = (String)("".equals(parent) ? "" : (String)parent + INTERNAL_SLASH) + parts[i];
            this.putIntoMap(this.dirFullPathMap, (String)parent, child);
            parent = child;
        }
    }

    private boolean isConsistent(String aFileName) {
        log.info("Archive is consistent");
        return true;
    }

    protected abstract void scanArchive(String var1);

    public ArchiveConfigProvider(String aArcPath) {
        this.arcFile = aArcPath;
        File file = new File(this.arcFile);
        if (!file.exists()) {
            throw new ConfigProviderException(String.format("The file  %s doesn't exist", this.arcFile));
        }
        if (file.isDirectory()) {
            throw new ConfigProviderException(String.format("The file or directory %s is a directory, but not a file", this.arcFile));
        }
        if (!this.isConsistent(this.arcFile)) {
            throw new ConfigProviderException(String.format("The file %s is inconsistent", this.arcFile));
        }
        this.scanArchive(this.arcFile);
    }

    private List<String> listItems(Map<String, TreeSet<String>> aMap, String aResourceDir, String aWildcard) {
        TreeSet<String> items = aMap.get(aResourceDir);
        if (items == null) {
            return Collections.emptyList();
        }
        return PathUtils.wildcardFilterGeneric(items, aWildcard);
    }

    @Override
    public List<String> listDirs(String aResourcePath, String aWildcardPattern) {
        return this.listItems(this.dirFullPathMap, aResourcePath, aWildcardPattern);
    }

    @Override
    public String getVersion() {
        String fileName = PathUtils.getOnlyNameOS(this.arcFile);
        if (!StringUtils.regexMatch(fileName, REGEX_BUNDLE)) {
            return fileName;
        }
        return PathUtils.getOnlyNameOS(this.arcFile).substring(7, 22);
    }

    @Override
    public String getSubdirNearResource(String aResourceName, String aSubdir) {
        return PathUtils.getSubdirAtFileDirGeneric(aResourceName, aSubdir);
    }

    @Override
    public List<String> listFiles(String aResourcePath, String aWildcardPattern, int aDepth) {
        if (aDepth < 1) {
            throw new ConfigProviderException(String.format("Depth %s cannot be less than 1", aDepth));
        }
        if (aDepth == 1) {
            return this.listFiles(aResourcePath, aWildcardPattern);
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String subdir : this.listDirs(aResourcePath, "*")) {
            result.addAll(this.listFiles(subdir, aWildcardPattern, aDepth - 1));
        }
        return result;
    }

    @Override
    public String getResourceInDir(String aResourceDirName, String aResourceName) {
        return PathUtils.joinPathGeneric(aResourceDirName, aResourceName);
    }

    @Override
    public List<String> listFiles(String aResourceDir, String aWildcard) {
        return this.listItems(this.fileFullPathMap, aResourceDir, aWildcard);
    }
}

