/*
 * Decompiled with CFR 0.152.
 */
package io.bidmachine.utils;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class HexParser {
    private static final String ERR = "Bad string %s: the part after '/' must be a valid hex of length 8 or 16";
    private static final String SLASH = "/";

    private HexParser() {
    }

    private static void raiseError(String s) {
        throw new NumberFormatException(String.format(ERR, s));
    }

    private static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    private static double hexToDouble(String aHexStr) {
        byte[] buffer = HexParser.hexStringToByteArray(aHexStr);
        return ByteBuffer.wrap(buffer).order(ByteOrder.LITTLE_ENDIAN).getDouble();
    }

    public static Double parseDouble(String s) {
        if (s == null || s.trim().isEmpty()) {
            return null;
        }
        int pos = s.indexOf(SLASH) + 1;
        if (s.length() - pos != 16) {
            HexParser.raiseError(s);
        }
        return HexParser.hexToDouble(s.substring(pos));
    }

    private static float hexToFloat(String aHexStr) {
        byte[] buffer = HexParser.hexStringToByteArray(aHexStr);
        return ByteBuffer.wrap(buffer).order(ByteOrder.LITTLE_ENDIAN).getFloat();
    }

    public static Float parseFloat(String s) {
        if (s == null || s.trim().isEmpty()) {
            return null;
        }
        int pos = s.indexOf(SLASH) + 1;
        if (s.length() - pos != 8) {
            HexParser.raiseError(s);
        }
        return Float.valueOf(HexParser.hexToFloat(s.substring(pos)));
    }
}

