package io.bidmachine.rollouts.model

import java.time.Instant

case class Feature(
  id: FeatureId,
  name: FeatureName,
  description: Option[FeatureDescription],
  samplingAttr: Option[AttributeId], // needs to be removed because samplingSettings was added (left for backward compatibility)
  samplingSettings: Option[SamplingSettings],
  defaults: List[Variable],
  rollouts: List[Rollout],
  experiments: List[Experiment],
  scope: Option[ScopeId],
  tags: Option[Set[Tag]],
  createdDate: Option[Instant],
  updatedDate: Option[Instant],
  version: Option[Long]
) {
  def withVersion(version: Long): Feature = this.copy(version = Some(version))
}
