package io.bidmachine.rollouts.model

import enumeratum._

abstract sealed class SamplingType extends EnumEntry

object SamplingType extends Enum[SamplingType] {

  case object Attribute extends SamplingType

  case object AttributePlusFeature extends SamplingType

  override def values: IndexedSeq[SamplingType] = findValues
}

final case class SamplingSettings(`type`: SamplingType, samplingAttr: AttributeId)
