package io.bidmachine.rollouts.model

import io.circe.Json

sealed trait VariableValue  extends Product with Serializable
sealed trait PrimitiveValue extends VariableValue

case class BooleanValue(bool: Boolean)              extends PrimitiveValue
case class IntValue(i: Int)                         extends PrimitiveValue
case class FloatValue(flt: Double)                  extends PrimitiveValue
case class StringValue(str: String)                 extends PrimitiveValue
case class JsonValue(json: Json)                    extends VariableValue
case class ArrayValue(values: List[PrimitiveValue]) extends VariableValue
