package io.bidmachine.rollouts.model.json

import io.bidmachine.rollouts.model._
import io.bidmachine.rollouts.targeting.validation.AttributeType
import io.circe.generic.semiauto.{deriveCodec, deriveDecoder, deriveEncoder}
import io.circe.refined._
import io.circe.{Codec, Decoder, Encoder}

trait RolloutsCodecs extends RulesCodecs with CoercibleCirce {

  implicit val primitiveValueEncoder: Encoder[PrimitiveValue] = deriveEncoder
  implicit val primitiveValueDecoder: Decoder[PrimitiveValue] = deriveDecoder

  implicit val variableValueEncoder: Encoder[VariableValue] = deriveEncoder
  implicit val variableValueDecoder: Decoder[VariableValue] = deriveDecoder

  implicit val variableEncoder: Encoder[Variable] = deriveEncoder
  implicit val variableDecoder: Decoder[Variable] = deriveDecoder

  implicit val valueTypeEncoder: Encoder[AttributeType] = enumeratum.Circe.encoderLowercase(AttributeType)
  implicit val valueTypeDecoder: Decoder[AttributeType] = enumeratum.Circe.decodeCaseInsensitive(AttributeType)

  implicit val attributeCodec: Codec[Attribute] = deriveCodec

  implicit val samplingTypeEncoder: Encoder[SamplingType] = enumeratum.Circe.encoderLowercase(SamplingType)
  implicit val samplingTypeDecoder: Decoder[SamplingType] = enumeratum.Circe.decodeCaseInsensitive(SamplingType)

  implicit val samplingSettingsCodec: Codec[SamplingSettings] = deriveCodec

  implicit val featureStatusEncoder: Encoder[FeatureStatus] = enumeratum.Circe.encoderLowercase(FeatureStatus)
  implicit val featureStatusDecoder: Decoder[FeatureStatus] = enumeratum.Circe.decodeCaseInsensitive(FeatureStatus)

  implicit val variantEncoder: Encoder[Variant] = deriveEncoder
  implicit val variantDecoder: Decoder[Variant] = deriveDecoder

  implicit val experimentEncoder: Encoder[Experiment] = deriveEncoder
  implicit val experimentDecoder: Decoder[Experiment] = deriveDecoder

  implicit val featureAllocationEncoder: Encoder[Allocation] = deriveEncoder
  implicit val featureAllocationDecoder: Decoder[Allocation] = deriveDecoder

  implicit val featureRolloutEncoder: Encoder[Rollout] = deriveEncoder
  implicit val featureRolloutDecoder: Decoder[Rollout] = deriveDecoder

  implicit val tagEncoder: Encoder[Tag] = deriveEncoder
  implicit val tagDecoder: Decoder[Tag] = deriveDecoder

  implicit val scopeEncoder: Encoder[Scope] = deriveEncoder
  implicit val scopeDecoder: Decoder[Scope] = deriveDecoder

  implicit val featureEncoder: Encoder[Feature] = deriveEncoder
  implicit val featureDecoder: Decoder[Feature] = deriveDecoder

  implicit val environmentEncoder: Encoder[Environment] = deriveEncoder
  implicit val environmentDecoder: Decoder[Environment] = deriveDecoder

  implicit val namespaceEncoder: Encoder[Namespace] = deriveEncoder
  implicit val namespaceDecoder: Decoder[Namespace] = deriveDecoder

  implicit val fullNamespaceEncoder: Encoder[NamespaceView] = deriveEncoder
  implicit val fullNamespaceDecoder: Decoder[NamespaceView] = deriveDecoder

}
