package io.bidmachine.rollouts.model.json

import cats.syntax.all._
import io.bidmachine.rollouts.targeting.ast.Value._
import io.bidmachine.rollouts.targeting.ast.{Attr, Op, Rule, Value}
import io.circe.derivation.deriveCodec
import io.circe.syntax._
import io.circe.{Codec, Decoder, Encoder, Json}

trait RulesCodecs {

  implicit val valueEncoder: Encoder[Value] = Encoder.instance {
    case BoolValue(b)    => Json.fromBoolean(b)
    case NumericValue(n) => Json.fromBigDecimal(n)
    case StringValue(s)  => Json.fromString(s)
    case ArrayValue(set) => set.asJson
    case NoneValue       => Json.Null
  }

  implicit val valueDecoder: Decoder[Value] = Decoder.instance(_.value.foldWith(ValueFolder).asRight)

  implicit val attrDecoder: Decoder[Attr] = Decoder[String].map(Attr.apply)
  implicit val attrEncoder: Encoder[Attr] = Encoder[String].contramap[Attr](_.id)

  implicit val opEncoder: Encoder[Op] = enumeratum.values.Circe.encoder(Op)
  implicit val opDecoder: Decoder[Op] = enumeratum.values.Circe.decoder(Op)

  implicit lazy val ruleCodec: Codec[Rule] = deriveCodec
}
