package io.bidmachine.rollouts.model

import io.bidmachine.rollouts.targeting.ast.Value
import io.circe.{DecodingFailure, Json, JsonNumber, JsonObject}

package object json {
  object all      extends RolloutsCodecs with RulesCodecs
  object rollouts extends RolloutsCodecs
  object rules    extends RulesCodecs

  object ValueFolder extends Json.Folder[Value] {
    override def onBoolean(value: Boolean)    = Value.BoolValue(value)
    override def onNumber(value: JsonNumber)  = Value.NumericValue(value.toDouble)
    override def onString(value: String)      = Value.StringValue(value)
    override def onArray(value: Vector[Json]) = Value.ArrayValue(value.map(_.foldWith(this)))
    override def onNull                       = Value.NoneValue

    override def onObject(value: JsonObject) = throw DecodingFailure("Value can't be JsonObject.", Nil)
  }
}
